% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{testForAllelicBiases}
\alias{testForAllelicBiases}
\title{Perform an allelic bias tests for each user region and bin.}
\usage{
testForAllelicBiases(SNPhood.o, readGroups, confLevel = 0.95,
  nullHypothesisFraction = 0.5, calcBackgroundDistr = TRUE,
  nRepetitions = 100, pValuesToTestBackground = c(1e-04, 5e-04, 0.001,
  0.005, seq(0.01, 1, 0.01)), verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{readGroups}{Character or NULL. Default NULL. Read groups that should be plotted, specified by their name as obtained by the function \code{annotationReadGroups}). If set to NULL, all read groups will be considered.}

\item{confLevel}{Numeric(1). Default 0.95. The confidence level for estimating the confidence intervals. Must be between 0 and 1.}

\item{nullHypothesisFraction}{Numeric(1). Default 0.5. The expected probability under the null hypothesis of not having any bias. Must be between 0 and 1.}

\item{calcBackgroundDistr}{Logical(1). Default \code{TRUE}. Should the background distribution be calculated? Note that this can be usually very time-consuming.}

\item{nRepetitions}{Integer(1). Default 10. Number of repetitions for calculating the background distribution. 
Only relevant if \code{calcBackgroundDistr} is set to \code{TRUE}}

\item{pValuesToTestBackground}{Numeric. Default c(0.0001, 0.0005, 0.001, 0.005, seq(0.01,1,0.01)). 
Set of p-values for which corresponding FDR values will be computed}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
Object of class \code{\linkS4class{SNPhood}} with all the data from the allelic bias test stored in the slot \code{additionalResults}, 
which can be easily retrieved via the accessor function \code{results}. 
See the help pages of the result function (?results) or the vignette for details.
}
\description{
\code{testForAllelicBiases} performs tests for allelic biases for each binned user region using binomial tests. 
For the parameter \code{readGroups}, the name of exactly two read groups must be provided for which allelic ratio tests should be performed.
See the Vignette for more details.
}
\examples{
data(SNPhood.o, package="SNPhood")
## Perform the test without calculating the background distribution  
SNPhood.o = testForAllelicBiases (SNPhood.o, readGroups = c("paternal","maternal"))
str(results(SNPhood.o, type="allelicBias"), list.len = 8)
## Check the parameters
results(SNPhood.o, type="allelicBias", elements = "parameters")
}

