% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_phenotypes.R
\name{predict_phenotypes}
\alias{predict_phenotypes}
\title{predict_phenotypes}
\usage{
predict_phenotypes(
  spe_object,
  thresholds = NULL,
  tumour_marker,
  baseline_markers,
  nuclear_marker = NULL,
  reference_phenotypes = FALSE,
  markers_to_phenotype = NULL,
  plot_distribution = TRUE
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{thresholds}{(Optional) Numeric Vector specifying the cutoff of a
positive reading. The order must match the marker order, and it should be
NA for DAPI.}

\item{tumour_marker}{String containing the tumour_marker used for the image.
If tumor cells are known, annotate tumor cells as 1 and non-tumor cells as
0, and include the rowname.}

\item{baseline_markers}{String Vector. Markers not found on tumour cells to
refine the threshold used for tumour cell phenotying.}

\item{nuclear_marker}{String. Nuclear marker used.}

\item{reference_phenotypes}{Boolean. TRUE or FALSE value whether there are reference
phenotypes for the sample obtained by the user through other means (e.g.
HALO or InForm). If there are reference phenotypes available, a matrix of
predicted phenotypes, intensities, and reference phenotypes will be
returned, which can be used as input to "marker_prediction_plot". If no
reference phenotype available, the result of the function will be added to
the spe object used in the input. Note that if a reference phenotype is to
be used, the phenotypes must be an explicit combination of positive markers
(e.g. AMACR,PDL1), as opposed to descriptive (PDL1+ tumour cells).}

\item{markers_to_phenotype}{String Vector. Markers to be included in the phenotyping. If
NULL, then all markers will be used. DAPI needs to be excluded.}

\item{plot_distribution}{Boolean. If TRUE, plots of the marker intensities
distributions and cutoffs are plotted.}
}
\value{
An updated spe object with cell phenotypes or a data.frame of
  predicted phenotypes
}
\description{
Predicts cell phenotypes based on marker intensity levels. If no
  prior cell phenotypes are available, it adds the phenotypes to the
  SpaitalExperiment object used as input. If reference cell phenotypes are
  available, it produces a density plot showing predicted cutoff of a
  positive reading for marker intensity and it returns a dataframe containing
  the predicted intensity status for a particular marker.
}
\examples{
# keep the original phenotypes
predicted_result <- predict_phenotypes(spe_object = simulated_image, thresholds = NULL,
tumour_marker = "Tumour_marker",baseline_markers = c("Immune_marker1", "Immune_marker2",
"Immune_marker3", "Immune_marker4"), reference_phenotypes = TRUE)
# update the predicted phenotypes
predicted_spe_image <- predict_phenotypes(spe_object = simulated_image, thresholds = NULL,
tumour_marker = "Tumour_marker",baseline_markers = c("Immune_marker1", "Immune_marker2",
"Immune_marker3", "Immune_marker4"), reference_phenotypes = FALSE)
}
