% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_spicey.R
\name{link_spicey}
\alias{link_spicey}
\title{Link RETSI regions to GETSI scores using gene-based association methods}
\usage{
link_spicey(retsi = NULL, getsi = NULL, annotation = NULL)
}
\arguments{
\item{retsi}{A data.frame containing RETSI scores for chromatin accessibility regions,
as returned by \code{compute_spicey_index()} using single-cell ATAC-seq differential accessibility data.
Must include at least the following columns:
\describe{
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800}).}
\item{cell_type}{Cell type or cluster label (e.g., \code{Acinar})}
\item{RETSI}{RETSI value: cell-type specificity score}
\item{norm_entropy}{Normalized Shannon entropy of RETSI}
}}

\item{getsi}{A data.frame containing GETSI scores for genes,
as returned by \code{compute_spicey_index()} using single-cell RNA-seq differential expression data.
Must include at least the following columns:
\describe{
\item{gene_id}{Identifier of the gene. Must be an official gene symbol (e.g., \code{GAPDH})}.
\item{cell_type}{Cell type or cluster label (e.g., \code{Acinar})}
\item{GETSI}{GETSI value: cell-type specificity score}
\item{norm_entropy}{Normalized Shannon entropy of GETSI}
}}

\item{annotation}{(Optional). A data.frame linking \code{gene_id} to \code{region_id}.
They should have the same names provided in the respective parameters.
This can be provided by the user or generated using the functions:
\code{\link{annotate_with_nearest}} or \code{\link{annotate_with_coaccessibility}}.
It should contain at least the following columns:
\describe{
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800}).
The name of this column should match the \code{region_id} argument.}
\item{cell_type}{Cell type or cluster label. (e.g., \code{Acinar})}
\item{gene_id}{Identifier of the gene. Must be an official gene symbol (e.g., \code{GAPDH}).
The name of this column should match the \code{gene_id} argument.}}}
}
\value{
A \code{data.frame} where each row represents a regulatory element–gene pair
linked within a given cell type. The output includes:
\describe{
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800})}
\item{gene_id}{Identifier of the gene. Must be an official gene symbol (e.g., \code{GAPDH})}.
\item{cell_type}{Cell type or cluster in which the association is observed (e.g., \code{Acinar})}
\item{RETSI}{RETSI score: regulatory element specificity in this cell type.}
\item{RETSI_entropy}{Normalized shannon-entropy of RETSI (lower = more specific).}
\item{GETSI}{GETSI score: gene expression specificity in this cell type.}
\item{GETSI_entropy}{Normalized shannon-entropy of GETSI (lower = more specific).}
\item{...}{Any additional columns from the original \code{retsi} and \code{getsi} inputs, suffixed
with \code{_ATAC} and \code{_RNA} respectively (e.g., \code{avg_log2FC_ATAC}, \code{p_val_RNA}).}
}
}
\description{
This function connects regulatory regions scored with RETSI
}
