% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_spongeffects_utility.R
\name{build_classifier_central_genes}
\alias{build_classifier_central_genes}
\title{build classifiers for central genes}
\usage{
build_classifier_central_genes(
  train_gene_expr,
  test_gene_expr,
  train_enrichment_modules,
  test_enrichment_modules,
  train_meta_data,
  test_meta_data,
  train_meta_data_type = "TCGA",
  test_meta_data_type = "TCGA",
  metric = "Exact_match",
  tunegrid_c = c(1:100),
  n.folds = 10,
  repetitions = 3
)
}
\arguments{
\item{train_gene_expr}{expression data of train dataset,
genenames must be in rownames}

\item{test_gene_expr}{expression data of test dataset,
genenames must be in rownames}

\item{train_enrichment_modules}{return of enrichment_modules()}

\item{test_enrichment_modules}{return of enrichment_modules()}

\item{train_meta_data}{meta data of train dataset}

\item{test_meta_data}{meta data of test dataset}

\item{train_meta_data_type}{TCGA or METABRIC}

\item{test_meta_data_type}{TCGA or METABRIC}

\item{metric}{metric (Exact_match, Accuracy) (default: Exact_match)}

\item{tunegrid_c}{defines the grid for the hyperparameter optimization during
cross validation (caret package) (default: 1:100)}

\item{n.folds}{number of folds to be calculated}

\item{repetitions}{number of k-fold cv iterations (default: 3)}
}
\value{
model for central genes
}
\description{
build classifiers for central genes
}
