% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCACheck.R
\name{PCACheck}
\alias{PCACheck}
\title{Population outlier check with SeqSQC object input file.}
\usage{
PCACheck(
  seqfile,
  remove.samples = NULL,
  npcs = 4,
  LDprune = TRUE,
  missing.rate = 0.1,
  ss.cutoff = 300,
  maf = 0.01,
  hwe = 1e-06,
  ...
)
}
\arguments{
\item{seqfile}{SeqSQC object, which includes the merged gds file
for study cohort and benchmark.}

\item{remove.samples}{a vector of sample names for removal from PCA
calculation. Could be problematic samples identified from
previous QC steps, or user-defined samples.}

\item{npcs}{the number principle components to use for the
population prediction in SVM model. The default value is 4, and
it is required to be <= 10.}

\item{LDprune}{whether to use LD-pruned snp set, the default is
TRUE.}

\item{missing.rate}{to use the SNPs with "<= \code{missing.rate}"
only; if NaN, no threshold. By default, we use
\code{missing.rate = 0.1} to filter out variants with missing
rate greater than 10\%.}

\item{ss.cutoff}{the minimum sample size (300 by default) to apply
the MAF filter. This sample size is the sum of study samples
and the benchmark samples of the same population as the study
cohort.}

\item{maf}{to use the SNPs with ">= \code{maf}" if sample size
defined in above argument is greater than \code{ss.cutoff};
otherwise NaN is used by default for no MAF threshold.}

\item{hwe}{to use the SNPs with Hardy-Weinberg equilibrium p >=
\code{hwe} if sample size defined in above argument is greater
than \code{ss.cutoff}; otherwise no hwe threshold. The default
is 1e-6.}

\item{...}{Arguments to be passed to other methods.}
}
\value{
a data frame with sample name, reported population, data
    resource (benchmark vs study cohort), the first four
    eigenvectors and the predicted population.
}
\description{
Function to perform principle component analysis for all samples
and to infer sample ancestry.
}
\details{
Using LD-pruned autosomal variants (by default), we
    calculate the eigenvectors and eigenvalues for principle
    component analysis (PCA). We use the benchmark samples as
    training dataset, and predict the population group for each
    sample in the study cohort based on the top four
    eigenvectors. Samples with discordant predicted and
    self-reported population groups are considered problematic. The
    function \code{PCACheck} performs the PCA analysis and
    identifies population outliers in study cohort.
}
\examples{
load(system.file("extdata", "example.seqfile.Rdata", package="SeqSQC"))
gfile <- system.file("extdata", "example.gds", package="SeqSQC")
seqfile <- SeqSQC(gdsfile = gfile, QCresult = QCresult(seqfile))
seqfile <- PCACheck(seqfile, remove.samples=NULL, LDprune=TRUE, missing.rate=0.1)
res.pca <- QCresult(seqfile)$PCA
tail(res.pca)
}
\author{
Qian Liu \email{qliu7@buffalo.edu}
}
\keyword{PCA}
