% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{generate_summarized_experiment}
\alias{generate_summarized_experiment}
\title{Generate SummarizedExperiment using multiple parameters}
\usage{
generate_summarized_experiment(
  annotation,
  count_matrix,
  tpm_matrix,
  name,
  spike_in_col,
  additional_cols,
  filter_genes,
  variance_cutoff,
  type_abundance_cutoff,
  scale_tpm
)
}
\arguments{
\item{annotation}{(mandatory) dataframe; needs columns 'ID' and 'cell_type'; 'ID' needs to be equal with cell_names in count_matrix}

\item{count_matrix}{(mandatory) sparse count matrix; raw count data is expected with genes in rows, cells in columns}

\item{tpm_matrix}{sparse count matrix; TPM like count data is expected with genes in rows, cells in columns}

\item{name}{name of the dataset; will be used for new unique IDs of cells}

\item{spike_in_col}{which column in annotation contains information on spike_in counts, which can be used to re-scale counts; mandatory for spike_in scaling factor in simulation}

\item{additional_cols}{list of column names in annotation, that should be stored as well in dataset object}

\item{filter_genes}{boolean, if TRUE, removes all genes with 0 expression over all samples & genes with variance below \code{variance_cutoff}}

\item{variance_cutoff}{numeric, is only applied if \code{filter_genes} is TRUE: removes all genes with variance below the chosen cutoff}

\item{type_abundance_cutoff}{numeric, remove all cells, whose cell-type appears less then the given value. This removes low abundant cell-types}

\item{scale_tpm}{boolean, if TRUE (default) the cells in tpm_matrix will be scaled to sum up to 1e6}
}
\value{
Return a \link[SummarizedExperiment]{SummarizedExperiment} object
}
\description{
Generate SummarizedExperiment using multiple parameters
}
\keyword{internal}
