% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{simulate_sample}
\alias{simulate_sample}
\title{simulate single pseudo-bulk sample}
\usage{
simulate_sample(
  data,
  scaling_vector,
  simulation_vector,
  total_cells,
  total_read_counts,
  remove_bias_in_counts,
  remove_bias_in_counts_method,
  norm_counts,
  seed
)
}
\arguments{
\item{data}{\link[SummarizedExperiment]{SummarizedExperiment} object}

\item{scaling_vector}{vector with scaling values for each cell; calculated by the \code{calc_scaling_vector} function}

\item{simulation_vector}{named vector with wanted cell-types and their fractions}

\item{total_cells}{numeric; number of total cells for this simulation}

\item{total_read_counts}{numeric; sets the total read count value for each sample}

\item{remove_bias_in_counts}{boolean; if TRUE (default) the internal mRNA bias that is present in count data will be \emph{removed} using the number of reads mapped to each cell}

\item{remove_bias_in_counts_method}{'read-number' (default) or 'gene-number'; method with which the mRNA bias in counts will be removed}

\item{norm_counts}{boolean; if TRUE the samples simulated with counts will be normalized to CPMs, default is FALSE}

\item{seed}{numeric; fix this value if you want the same cells to be sampled}
}
\value{
returns two vectors (one based on counts, one based on tpm; depends on which matrices are present in data) with expression values for all genes in the provided dataset
}
\description{
function to sample cells according to given cell-type fractions. This creates a single pseudo-bulk sample by calculating the
mean expression value per gene over all sampled cells.
Note: if total_read_counts is used, the cell-fractions are applied to the number of counts, not the number of cells!
}
\keyword{internal}
