% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting.r
\name{BinMethylation}
\alias{BinMethylation}
\title{Summarize methylation inside sorting bins}
\usage{
BinMethylation(MethSM, Bin)
}
\arguments{
\item{MethSM}{Single molecule matrix}

\item{Bin}{IRanges object with absolute coordinates for single sorting bin.}
}
\value{
Reads covering bin with their summarized methylation status
}
\description{
Summarize methylation inside sorting bins
}
\examples{

library(IRanges)
library(GenomicRanges)

MethSM = qs::qread(system.file("extdata", "Methylation_4.qs", 
package="SingleMoleculeFootprinting"))[[2]]$SMF_MM_TKO_DE_

TFBSs = qs::qread(system.file("extdata", "TFBSs_1.qs", 
package="SingleMoleculeFootprinting"))

motif_center_1 = start(IRanges::resize(TFBSs[1], 1, "center"))
motif_center_2 = start(IRanges::resize(TFBSs[2], 1, "center"))
SortingBins = c(
GRanges("chr6", IRanges(motif_center_1-35, motif_center_1-25)),
GRanges("chr6", IRanges(motif_center_1-7, motif_center_1+7)),
GRanges("chr6", IRanges(motif_center_2-7, motif_center_2+7)),
GRanges("chr6", IRanges(motif_center_2+25, motif_center_2+35))
)

binMethylationValues = BinMethylation(MethSM = MethSM, Bin = SortingBins[1])

}
