% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling_utils.r
\name{MaskSNPs}
\alias{MaskSNPs}
\title{Utility function to remove cytosines whose MTase target genomic context is affected by SNPs}
\usage{
MaskSNPs(
  Methylation,
  CytosinesToMask,
  MaskSMmat = FALSE,
  SampleStringMatch = list(Cast = "_CTKO", Spret = "_STKO"),
  Experiment
)
}
\arguments{
\item{Methylation}{as output by the CallContextMethylation() function}

\item{CytosinesToMask}{GRanges specifying the coordinate of the cytosines to discard.}

\item{MaskSMmat}{whether the parameter Methylation includes single molecule matrixes}

\item{SampleStringMatch}{list of per-sample string matches that are used to uniquely identify the relevant column for each species in the Methylation object. Defaults to list(Cast = "_CTKO", Spret = "_STKO")}

\item{Experiment}{as detected by the DetectExperimentType() function. Should be either "DE" or "NO"}
}
\description{
Utility function to remove cytosines whose MTase target genomic context is affected by SNPs
}
\examples{

Methylation = qs::qread(system.file("extdata", "Methylation_2.qs", 
package="SingleMoleculeFootprinting"))
CytosinesToMask = qs::qread(system.file("extdata", "cytosines_to_mask.qs", 
package="SingleMoleculeFootprinting"))

MaskSNPs(Methylation = Methylation, CytosinesToMask = CytosinesToMask, MaskSMmat = FALSE, 
SampleStringMatch = list(Cast = "_CTKO", Spret = "_STKO"), Experiment = "DE") -> Methylation_masked

}
