% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting.r
\name{StateQuantificationByTFPair}
\alias{StateQuantificationByTFPair}
\title{Convenience for calculating state frequencies after sorting reads by TF pair}
\usage{
StateQuantificationByTFPair(SortedReads)
}
\arguments{
\item{SortedReads}{List of sorted reads (can be multiple samples) as returned by SortReadsByTFCluster run for clusters of size 2 (or SortReads run with analogous parameters)}
}
\value{
tibble with state frequency information
}
\description{
wraps around StateQuantification function
}
\examples{

Methylation = qs::qread(system.file("extdata", "Methylation_4.qs", 
package="SingleMoleculeFootprinting"))
TFBSs = qs::qread(system.file("extdata", "TFBSs_1.qs", 
package="SingleMoleculeFootprinting"))
SortedReads = SortReadsByTFCluster(MethSM = Methylation[[2]], TFBS_cluster = TFBSs)
StateQuantificationByTFPair(SortedReads = SortedReads)

}
