% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_series_clustering.R
\name{clusterTS}
\alias{clusterTS}
\title{Perform Clustering on Time-Series Data}
\usage{
clusterTS(x, k = 5, pCut = NULL, twoCondition = FALSE)
}
\arguments{
\item{x}{A numeric \code{matrix} with rows as features and columns as time
points.}

\item{k}{A \code{numeric} value specifying the number of clusters. Default is
5.}

\item{pCut}{A \code{numeric} value specifying the probability cutoff for
cluster membership. Default is \code{NULL}.}

\item{twoCondition}{A \code{logical} value indicating if the data contains
two conditions. Default is \code{FALSE}.}
}
\value{
A list containing:
\item{cluster}{A \code{tibble} with clustering information for each feature.}
\item{plot}{A \code{ggplot2} object for visualizing the clustering results.}
}
\description{
\code{clusterTS} performs clustering on time-series data and generates plots
for visualization.
}
\details{
The function performs the following steps:
\enumerate{
  \item Sets a seed for reproducibility.
  \item Removes rows with missing values.
  \item Performs clustering using fuzzy C-means.
  \item Filters clusters based on the probability cutoff if provided.
  \item Generates plots for visualizing clustering results.
}
}
\examples{
library(SummarizedExperiment)
# Load multiAssayExperiment object
data("dia_example")
# Get SummarizedExperiment object
se <- dia_example[["Phosphoproteome"]]
colData(se) <- colData(dia_example)
seProcess <- preprocessPhos(seData = se, normalize = TRUE, impute = "QRILC")
result <- addZeroTime(seProcess, condition = "treatment", treat = "EGF",
zeroTreat = "1stCrtl", timeRange = c("20min","40min", "6h"))
# Get the numeric matrix
exprMat <- assay(result)
# Call the function
clusterTS(x = exprMat, k = 3)

}
