% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinase_activity.R
\name{getDecouplerNetwork}
\alias{getDecouplerNetwork}
\title{Load Kinase-Substrate Interaction Network}
\usage{
getDecouplerNetwork(speciesRef = c("Homo sapiens", "Mus musculus"))
}
\arguments{
\item{speciesRef}{A \code{character} string specifying the species. Supported
values are "Homo sapiens" and "Mus musculus". Default is "Homo sapiens".}
}
\value{
A \code{data frame} containing the kinase-substrate interaction
network for the specified species.
}
\description{
\code{getDecouplerNetwork} loads the kinase-substrate interaction network for
 a specified species from pre-defined files.
}
\examples{
# Load the human kinase-substrate interaction network
getDecouplerNetwork("Homo sapiens")

# Load the mouse kinase-substrate interaction network
getDecouplerNetwork("Mus musculus")

}
