% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdutils.R
\name{.row_t_test}
\alias{.row_t_test}
\title{Perform row-wise t-tests from scratch}
\usage{
.row_t_test(in.data, region, min_bins = 50, ...)
}
\arguments{
\item{in.data}{A numeric matrix. Rows represent features, columns represent samples.}

\item{region}{A factor or vector indicating the group membership for each column of \code{in.data}.
Must have exactly two levels/unique values. Its length must equal \code{ncol(in.data)}.}

\item{min_bins}{Minimum number of non-missing observations required in each group to perform the t-test.}

\item{...}{Additional parameters to pass to the t-test function.}
}
\value{
A matrix with rows corresponding to the features and columns:
- \code{statistic}: The calculated t-statistic.
- \code{p.value}: The calculated two-sided p-value.
- \code{n1}: Number of non-missing observations in group 1 for that row.
- \code{n2}: Number of non-missing observations in group 2 for that row.
}
\description{
This function iterates over the rows of a matrix and performs a
t-test comparing two groups of columns. It calculates the t-statistic, p-value,
and sample sizes without relying on \code{stats::t.test()} for the core logic.
}
