% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeThresholdFlags}
\alias{computeThresholdFlags}
\title{computeThresholdFlags}
\usage{
computeThresholdFlags(spe, totalThreshold = 0, ctrlTotRatioThreshold = 0.1)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with spatial transcriptomics data.}

\item{totalThreshold}{A numeric value for the threshold of total counts to
identify cells with low counts. Default is `0`.}

\item{ctrlTotRatioThreshold}{A numeric value for the threshold of
control-to-total ratio to flag cells over a certain threshold. Default is
`0.1`.}
}
\value{
The `SpatialExperiment` object with added filter flags in `colData`.
}
\description{
Compute Flagged cells using fixed thresholds for SpatialExperiment.

This function calculates flagged cells only for total counts and control on
total probe counts ratio using fixed thresholds for a `SpatialExperiment`
object.
}
\details{
The function flags cells basing on zero counts and control-to-total
ratio to identify junk cells.
It also combines these flags into a single filter flag.
}
\examples{
example(readCosmxSPE)
spe <- spatialPerCellQC(spe)
spe <- computeThresholdFlags(spe)
table(spe$threshold_flags)
}
