% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{parseSpotFile}
\alias{parseSpotFile}
\title{Parse spot detector output}
\usage{
parseSpotFile(file)
}
\arguments{
\item{file}{spot file}
}
\value{
\code{\link[base]{data.frame}} with columns "x" and "y" specifying
the pixel coordinates of each spot
}
\description{
Parses the output from the ST spot detector tool for use with SpatialCPie.
}
\examples{
## Create spot file
data <- rbind(
    c(7, 18, 7.00, 18.07, 563.2, 947.0),
    c(8, 11, 8.00, 11.04, 612.5, 627.7)
)
filename <- tempfile()
write.table(
    data,
    file = filename,
    sep = "\\t",
    quote = FALSE,
    col.names = c("x", "y", "new_x", "new_y", "pixel_x", "pixel_y")
)

## Parse spot file
parseSpotFile(filename)

## Delete spot file
unlink(filename)
}
