% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{csvToParquetPaths}
\alias{csvToParquetPaths}
\title{If transcripts or polygon is expected to be loaded, write a parquet file to
the current data download (if not already), and return the file path to .parquet}
\usage{
csvToParquetPaths(dirName, filepath = "tx_csv_path")
}
\arguments{
\item{dirName}{current directory of data download}

\item{filepath}{path to transcripts or polygons csv}
}
\value{
a path to .parquet
}
\description{
If transcripts or polygon is expected to be loaded, write a parquet file to
the current data download (if not already), and return the file path to .parquet
}
\examples{
dir <- system.file(file.path("extdata", "CosMx_small"),
                   package = "SpatialExperimentIO")
tx_csv_path <- file.path(dir, "lung_p9s1_tx_file.csv")
tx_parquet_path <- csvToParquetPaths(dirName, filepath = tx_csv_path)

}
\author{
Yixing Estella Dong
}
