dir <- system.file(
  file.path("extdata", "MERSCOPE_small"), 
  package="SpatialExperimentIO")

test_that("example data folders uniquely contains needed files", {
  expect_true("ovarian_p2s2_cell_by_gene.csv" %in% list.files(dir))
  expect_true("ovarian_p2s2_cell_metadata.csv" %in% list.files(dir)) 
  
  expect_length(list.files(dir, "cell_by_gene.csv"), 1)
  expect_length(list.files(dir, "cell_metadata.csv"), 1)
})

test_that("needed files contains spatial columns of interest", {
  metadata <- read.csv(file.path(dir, "ovarian_p2s2_cell_metadata.csv"))
  
  expect_true(all(c("center_x", "center_y") %in% colnames(metadata))) 
  expect_true(is.numeric(metadata$center_x))
  expect_true(is.numeric(metadata$center_y))
})

test_that("data are read correctly to SpatialExperiment class", {
  x <- readMerscopeSXE(dirName = dir, 
                       returnType = "SPE",
                       countMatPattern = "cell_by_gene.csv", 
                       metaDataPattern = "cell_metadata.csv", 
                       coordNames = c("center_x", "center_y"))
  
  expect_s4_class(x, "SpatialExperiment")
  expect_true(all(colnames(SpatialExperiment::spatialCoords(x)) == c("center_x", "center_y")))
  expect_false(is.null(rownames(x)))
  expect_false(is.null(colnames(x)))
  expect_true(all(dim(x) == c(9, 8)))
  expect_s4_class(SingleCellExperiment::counts(x), "dgCMatrix")
})

test_that("data are read correctly to SingleCellExperiment class", {
  x <- readMerscopeSXE(dirName = dir, 
                       returnType = "SCE",
                       countMatPattern = "cell_by_gene.csv", 
                       metaDataPattern = "cell_metadata.csv", 
                       coordNames = c("center_x", "center_y"))
  
  expect_s4_class(x, "SingleCellExperiment")
  expect_true(all(c("center_x", "center_y") %in% colnames(SingleCellExperiment::colData(x))))
  expect_false(is.null(rownames(x)))
  expect_false(is.null(colnames(x)))
  expect_true(all(dim(x) == c(9, 8)))
  expect_s4_class(SingleCellExperiment::counts(x), "dgCMatrix")
})
