\name{Team}
\Rdversion{1.1}
\docType{class}
\alias{Team-class}
\alias{MulticoreTeam-class}
% *Team-methods
\alias{Team}
\alias{Team,missing-method}
\alias{Team,MulticoreParam-method}


\title{Consumer classes for parallel evaluation}

\description{

  A \code{\linkS4class{Consumer}} to divide incoming tasks amongst
  processes for parallel evaluation; not supported on Windows.

}

\usage{
Team(FUN, ..., param)
}

\arguments{

  \item{FUN}{A \code{function} of one argument (the input to this
    consumer), to be applied to each element of the stream. The return
    value of the function is the value yield'ed.}

  \item{...}{Additional arguments (e.g., \code{verbose}, passed to the
    \code{\linkS4class{Consumer}} constructor.}

  \item{param}{If provided, a \code{ParallelParam} instance, such as
    generated by \code{MulticoreParam()}.}

}

\section{Constructors}{
  Use \code{Team} to construct instances of this class.

  When \code{param} is missing, \code{Team} consults the registry (see
  \code{\link{register}}) for a parallel parameter class. If none is
  found and \code{.Platform$OS.type == "unix"}, a default
  \code{\link{MulticoreParam}} instance is used. An error is signaled on
  other operating systems (i.e., Windows)

}

\section{Methods}{See \code{\link{Consumer}} Methods.}

\section{Internal Class Fields and Methods}{

  Internal fields of this class are are described with, e.g.,
  \code{getRefClass("MulticoreTeam")$fields}.

  Internal methods of this class are described with
  \code{getRefClass("MulticoreTeam")$methods()} and
  \code{getRefClass("MulticoreTeam")$help()}.

}

\author{Martin Morgan \url{mtmorgan@fhcrc.org}}

\seealso{

  \code{\link{ParallelParam}} for configuring parallel
  environments. \code{\link{DAGTeam}} apply functions organized as a
  directed acyclic graph.

}

\examples{
if (.Platform$OS.type != "windows") {
    param <- MulticoreParam(size=5)
    team <- Team(function(x) { Sys.sleep(1); mean(x) }, param=param)
    s <- Stream(Seq(to=50, yieldSize=5), team)
    system.time({while(length(y <- yield(s)))
        print(y)
    })  ## about 2 seconds
}
}

\keyword{classes}
