% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownloadArchS4.R
\name{DownloadArchS4}
\alias{DownloadArchS4}
\title{DownloadArchS4 function}
\usage{
DownloadArchS4(GSM, species, print_tsv = FALSE, filename = NULL)
}
\arguments{
\item{GSM}{Vector with the GSM ids of the samples to consider.}

\item{species}{Specify the specie of yuor GSM samples. Either human or mouse.}

\item{print_tsv}{Logical. If \code{TRUE}, outputs a tsv file with the count matrix. By default, FALSE.}

\item{filename}{Name of the tsv output file. Default is matrix.tsv.}
}
\value{
A count matrix with gene on the row and GSM ID on the column.
}
\description{
Download count matrix from \url{https://maayanlab.cloud/archs4/},
given a vector of input GEO Sample accessions numbers (GSM).
}
\section{Warning}{

If the defined GSM ids do not have any match in ArchS4 database, we suggest to contact ArchS4 curator to add them.
}

\examples{
\dontrun{
GSM <- c("GSM3447008", "GSM3447009")
GEO_count_matrix <- DownloadArchS4(GSM, species = "human",
                                  print_tsv = FALSE, filename = NULL)}
}
\seealso{
\code{\link{GEOmetadata}} function for downloading GEO metadata.
\url{https://www.ncbi.nlm.nih.gov/geo} for info on GSM.
\url{https://maayanlab.cloud/archs4/} for info on ArchS4.

Other public-data functions: 
\code{\link{GEOmetadata}()},
\code{\link{TCGA_download}()}
}
\concept{public-data functions}
