% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{signatureHeatmap}
\alias{signatureHeatmap}
\title{Plot a heatmap of signature scores.}
\usage{
signatureHeatmap(
  inputData,
  annotationData = NULL,
  name = "Signatures",
  signatureColNames,
  annotationColNames = NULL,
  colList = list(),
  scale = FALSE,
  showColumnNames = TRUE,
  showRowNames = TRUE,
  colorSets = c("Set1", "Set2", "Set3", "Pastel1", "Pastel2", "Accent", "Dark2",
    "Paired"),
  choose_color = c("blue", "gray95", "red"),
  split_heatmap = "none",
  annotationSignature = sigAnnotData,
  column_order = NULL,
  cluster_columns = TRUE,
  ...
)
}
\arguments{
\item{inputData}{an input data object. It should either be of the class
\code{SummarizedExperiment} and contain the profiled signature data and
annotation data as columns in the colData, or alternatively be of the classes
\code{data.frame} or \code{matrix} and contain only the gene expression data.
Required.}

\item{annotationData}{a \code{data.frame} or \code{matrix} of annotation
data, with one column. Only required if \code{inputData} is a
\code{data.frame} or \code{matrix} of signature data.
The row names must equal those of the \code{inputData} column names.
Default is \code{NULL}.}

\item{name}{a character string with the plot title of the heatmap. The
default is \code{"Signatures"}.}

\item{signatureColNames}{a vector of the column names in \code{colData} that
contain the signature data. Only required if \code{inputData} is a
SummarizedExperiment object.}

\item{annotationColNames}{a vector of the column names in \code{colData} that
contain the annotation data. Only required if \code{inputData} is a
\code{SummarizedExperiment}. Default is \code{NULL}.}

\item{colList}{a named \code{list} of named vectors specifying custom color
information to
pass to \code{ComplexHeatmap::Heatmap()}. The list should have as many
elements as there are annotation columns, and each element name should
correspond exactly with the name of each annotation column.
The colors in the vector elements should be named according to the
levels of the factor in that column's annotation data if the annotation
is discrete, or it should be produced with \code{circlize::colorRamp2}
if the annotation is continuous.
By default, \code{ColorBrewer} color sets will be used.
See the the parameter \code{colorSets} for additional details.}

\item{scale}{logical. Setting \code{scale = TRUE} scales the signature data.
The default is \code{FALSE}.}

\item{showColumnNames}{logical. Setting \code{showColumnNames = TRUE} will
show the column names (i.e. sample names) on the heatmap. The default is
\code{TRUE}.}

\item{showRowNames}{logical. Setting \code{showColumnNames = TRUE} will
show the row names (i.e. signature names) on the heatmap. The default is
\code{TRUE}.}

\item{colorSets}{a vector of names listing the color sets in the order
that they should be used in creating the heatmap. By default, this function
will use the color sets in the order listed in \code{Usage} for annotation
information. You may replace the default with the same collection of sets
in order that you want to use them, or provide custom color sets with the
\code{colList} parameter.}

\item{choose_color}{a vector of color names to be interpolated for the
heatmap gradient, or a \code{colorRamp} function produced by
\code{circlize::colorRamp2}. The default is \code{c("blue", "gray95", "red")}.}

\item{split_heatmap}{a character string either giving the column title of
\code{annotationSignature} containing annotation data for which to split
the heatmap rows (i.e., signatures), or \code{"none"} if no split is desired.
To split based on the type of signature, set \code{split_heatmap = "disease"}.
The default is \code{"none"}.}

\item{annotationSignature}{a \code{data.frame} or \code{matrix} with information
to be used
in splitting the heatmap. The first column should signature names. The
column of annotation information should be specified in \code{split_heatmap.}
Other columns will be ignored. The default is \code{sigAnnotData}.}

\item{column_order}{a vector of character strings indicating the order in
which to manually arrange the heatmap columns. Default is \code{NULL},
such that column order is automatically determined via clustering.}

\item{cluster_columns}{A logical indicating whether columns (samples)
should be clustered together. Must be \code{FALSE} if user supplies
\code{column_order}. Default is \code{TRUE}.}

\item{...}{Additional arguments to be passed to
\code{ComplexHeatmap::Heatmap()}.}
}
\value{
A ComplexHeatmap plot.
}
\description{
This function takes a dataset of scored gene expression data as an input
and returns a \code{ComplexHeatmap} plot for for visual comparison of
signature performance. The function takes arguments listed here as well
as any others to be passed on to \code{ComplexHeatmap::Heatmap()}.
}
\details{
If both \code{annotationData = NULL} and \code{annotationColNames = NULL},
no annotation bar will be drawn on the heatmap.
}
\examples{
library(SummarizedExperiment)
# Generate some artificial data that shows a difference in Zak_RISK_16
mat_testdata <- rbind(matrix(c(rnorm(80), rnorm(80) + 5), 16, 10,
                             dimnames = list(TBsignatures$Zak_RISK_16,
                                             paste0("sample", seq_len(10)))),
                      matrix(rnorm(1000), 100, 10,
                             dimnames = list(paste0("gene", seq_len(100)),
                                             paste0("sample", seq_len(10)))))
# Create a SummarizedExperiment object that contains the data
testdataSE <- SummarizedExperiment(assays = SimpleList(data = mat_testdata),
                                     colData = DataFrame(sample =
                                                           c(rep("down", 5),
                                                                rep("up", 5))))
res <- runTBsigProfiler(testdataSE, useAssay = "data",
                        signatures = TBsignatures["Zak_RISK_16"],
                        algorithm = c("GSVA", "ssGSEA"), parallel.sz = 1,
                        combineSigAndAlgorithm = TRUE)
signatureHeatmap(res, signatureColNames = c("GSVA_Zak_RISK_16",
                                            "ssGSEA_Zak_RISK_16"),
                 annotationColNames = "sample", scale = TRUE,
                 showColumnNames = FALSE, split_heatmap = "none")

# Example using custom colors for the annotation information
color2 <- stats::setNames(c("purple", "black"), c("down", "up"))
color.list <- list("sample" = color2)

signatureHeatmap(res, signatureColNames = c("GSVA_Zak_RISK_16",
                                            "ssGSEA_Zak_RISK_16"),
                 annotationColNames = "sample", scale = TRUE,
                 showColumnNames = FALSE,
                 colList = color.list, split_heatmap = "none")

}
