% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countReads.R
\name{countReads}
\alias{countReads}
\title{count mapped reads overlap genomic intervals}
\usage{
countReads(object, dir, method = "summarizeoverlaps", zero.based = TRUE, ...)
}
\arguments{
\item{object}{a \code{TCA} object.}

\item{dir}{character string giving the directory of BAM files.}

\item{method}{character string giving the counting method. Options
are "\code{summarizeOverlaps}" and "\code{featureCounts}". For
Windows system, only "\code{summarizeOverlaps}" can be used, For
Linux system, both methods can be used.}

\item{zero.based}{Logical. If TRUE, the start positions of the
genomic intervals are \emph{0-based}, if FALSE, the start positions
will be \emph{1-based}.}

\item{...}{additional arguments passed to
\code{\link{summarizeOverlaps}} in GenomicAlignments package 
or \code{\link{featureCounts}} in Rsubread package.}
}
\value{
A TCA object with updated \code{count} slot.
}
\description{
This function counts mapped reads from multiple BAM files 
overlapping genomic intervals in \code{genomicFeature} in a 
\code{TCA} object. The resulted count table is stored in 
\code{count} slot of the \code{TCA} object.
}
\details{
This function provides two options to count the mapped reads: 
"\code{summarizeOverlaps}" in the GenomicAlignments package and 
"\code{featureCounts}" in the Rsubread package. As Rsubread package 
is only avaible for linux systems, Windows users can only choose
"\code{summarizeOverlaps}". The user could further customize the 
counting paramters by passing additional arguments (...), otherwise 
the default settings of the two methods will be used. For details 
of the counting parameters, see \code{\link{summarizeOverlaps}}, 
\code{\link{featureCounts}}.
}
\seealso{
\code{\link{summarizeOverlaps}}, \code{\link{featureCounts}}
}
\author{
Mengjun Wu
}
