% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{resolveAmbiguousProteinNames}
\alias{resolveAmbiguousProteinNames}
\title{Resolve ambiguous protein names}
\usage{
resolveAmbiguousProteinNames(df, includeIsoforms = FALSE)
}
\arguments{
\item{df}{tidy data_frame retrieved after 
import of a 2D-TPP dataset}

\item{includeIsoforms}{logical indicating
whether protein isoform should be kept for
analysis}
}
\value{
data frame with resolved protein name
ambiguity
}
\description{
Resolve ambiguous protein names
}
\examples{
tst_df <- bind_rows(tibble(representative = rep(1:3, each = 3), 
                           clustername = rep(letters[1:3], each = 3)), 
                    tibble(representative = rep(c(4, 5), c(3, 2)), 
                           clustername = rep(c("a", "b"), c(3, 2))))
                           
resolveAmbiguousProteinNames(tst_df)
}
