% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perCellEntropy.R
\name{perCellEntropy}
\alias{perCellEntropy}
\alias{perCellEntropy,ANY-method}
\alias{perCellEntropy,SummarizedExperiment-method}
\title{Compute the per-cell entropy}
\usage{
perCellEntropy(x, ...)

\S4method{perCellEntropy}{ANY}(x, BPPARAM = NULL)

\S4method{perCellEntropy}{SummarizedExperiment}(x, ..., assay.type = "counts")
}
\arguments{
\item{x}{A numeric matrix-like object containing counts for each cell (column) and feature (row).
Alternatively, a \linkS4class{SummarizedExperiment} object containing such a matrix.}

\item{...}{For the generic, further arguments to pass to specific methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.}

\item{BPPARAM}{A BiocParallelParam object from \pkg{BiocParallel}, specifying how calculations should be parallelized.}

\item{assay.type}{An integer or string specifying the assay to use from a SummarizedExperiment \code{x}.}
}
\value{
A numeric vector of entropies for all cells in \code{x}.
Cells with all-zero values in \code{x} will be assigned \code{NA} entropies.
}
\description{
Compute the entropy of each cell, using this as a proxy for the differentiation status.
}
\details{
Entropy values are computed from the proportion of counts assigned to each feature within a given cell.
The central idea is that undifferentiated cells have higher entropies because they are not yet committed to a single lineage,
and thus have low but persistent activity of the transcriptional programs for all lineages.
The cluster with the highest entropy values can be used to determine the \code{start} cluster in \code{\link{orderCells}}.
}
\examples{
sce <- scuttle::mockSCE()
ent <- perCellEntropy(sce)
summary(ent)

# Compute average entropy over mock clusters.
clusters <- sample(ncol(sce), 5)
by.cluster <- split(ent, clusters)
mean.cluster.ent <- vapply(by.cluster, mean, 0)

}
\references{
Grun D et al. (2016). 
De novo prediction of stem cell identity using single-cell transcriptome data.
\emph{Cell Stem Cell} 19, 266-77

Gulati GS et al. (2020).
Single-cell transcriptional diversity is a hallmark of developmental potential.
\emph{Science} 367, 405-11

Guo M et al. (2017)
SLICE: determining cell differentiation and lineage based on single cell entropy.
\emph{Nucleic Acids Res.} 45, e54
}
\author{
Aaron Lun
}
