\name{Write.Results}
\alias{Write.Results}
\title{Save TargetSearch result objects into files}
\description{
  This is a convenient function to save the TargetSearch result into tab-delimited
  text files.
}
\usage{
Write.Results(Lib, metabProfile,
              quantMatrix=c('quantmass', 'maxint', 'maxobs', 'none'),
              prefix = NULL,
              selmass = FALSE)
}
\arguments{
  \item{Lib}{ A \code{tsLib} object. }
  \item{metabProfile}{ A \code{tsProfile} object. The final result of the package.
    This object is generated by either \code{Profile} or \code{ProfileCleanUp}. }
  \item{quantMatrix}{ Should an intensity matrix using quantification masses be
    created? This parameter will be passed to \code{\link{quantMatrix}} and
    indicates whether the quantification mass should be either taken as is from
    the \code{Lib} object (as specified by the method \code{\link{quantMass}}),
    or chosen based on intensity or observations. The file will have the extension
    \sQuote{.profile.quantmatrix.txt}, unless this is set to \code{none}, in which case
    the file will not be created.}
  \item{prefix}{ A character string. This is a file name prefix for the output
    text files. If it is set to \code{NULL} or \code{NA}, then
    \code{"TargetSearch-YYYY-MM-DD"} is used by default, where Y/M/D represents the
    year, month and day of today's date.}
  \item{selmass}{ Logical. This parameter is passed to the function
    \code{\link{quantMatrix}}. See that function documentation for its meaning.}
}
\details{
  The function generates the following tab-delimited text files, where \dQuote{prefix}
  corresponds   with the selected file prefix.
  \itemize{
    \item \code{prefix.peak.intensity.txt}. Contains information on peak intensity
      for each target mass in the library per sample.
    \item \code{prefix.peak.RI.txt}. Contains information on retention index
      (RI) for each target mass in the library per sample.
    \item \code{prefix.profile.info.txt}. Contains the profile information for
      each metabolite. See \code{\link{Profile}} and \code{\link{ProfileCleanUp}}
      for details.
    \item \code{prefix.profile.intensities.txt}. Contains information on profile
      intensities per metabolite. This value is an average of all correlating
      masses normalized to the mean.
    \item \code{prefix.profile.ri.txt}. Contains information on average retention
      indices of the correlating masses. This value is an average of all correlating
      masses.
    \item \code{prefix.profile.quantmatrix.txt}. The quantification matrix
      as tab-delimited text file. See \code{\link{quantMatrix}} for details.
      If the argument \code{quantMatrix} is equal to \dQuote{none}, then this
      file is not created.
  }

  The functions uses \code{\link[utils]{write.table}} as backend to write the files
  with parameters \code{set="\t"} and \code{quote=FALSE}.
}
\value{
This function does not return anything. It just prints a message with the saved files.
}
\author{Alvaro Cuadros-Inostroza, Matthew Hannah, Henning Redestig }
\seealso{ \code{\link{peakFind}}, \code{\link{Profile}}, \code{\link{ProfileCleanUp}},
\code{\linkS4class{tsLib}}, \code{\linkS4class{tsMSdata}}, \code{\linkS4class{tsProfile}},
\code{\link{quantMatrix}} }
\examples{
# load precomputed results from `TSExample`
data(TSExample)

# we need the objects metabProfile and refLibrary. This will create files
# with prefix 'TargetSearch-YYYY-MM-DD' corresponding to today's date
Write.Results(refLibrary, metabProfile)

# change the prefix with the parameter `prefix` to 'my_experiment'
Write.Results(refLibrary, metabProfile, prefix='my_experiment')
}
% vim: set ts=2 sw=2 et:
