% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntBoard.R
\name{knit_print.TnTBoard}
\alias{knit_print.TnTBoard}
\title{Printing TnTBoard in Rmarkdown}
\usage{
\method{knit_print}{TnTBoard}(x, ..., options = NULL)
}
\arguments{
\item{x}{A TnTBoard or TnTGenome object.}

\item{..., options}{Passed to \code{htmlwidget:::knit_print.htmlwidget}.}
}
\value{
\code{htmlwidget:::knit_print.htmlwidget} invisibly returns a character
    vector with "browsable_html" S3 class.
}
\description{
S3 method to automatically render a TnTBoard with knitr.
}
\examples{
track <- BlockTrack(GRanges("chr12", IRanges(c(100, 400, 700), width = 100)),
                    color = c("green", "red", "blue"))
tntboard <- TnTGenome(track)
\dontrun{
knitr::knit_print(tntboard)
}
}
\references{
\code{\link[knitr]{knit_print}}
}
