% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntTracks.R, R/tntBoard.R,
%   R/tntTracks-compositeTrack.R
\name{seqinfo}
\alias{seqinfo}
\alias{seqinfo<-,RangeBasedTrack-method}
\alias{seqinfo,RangeBasedTrack-method}
\alias{seqlevelsInUse,RangeBasedTrack-method}
\alias{seqinfo,TnTBoard-method}
\alias{seqinfo,CompositeTrack-method}
\alias{seqinfo<-,CompositeTrack-method}
\alias{seqlevelsInUse,CompositeTrack-method}
\title{Seqinfo of TnTTrack and TnTBoard}
\usage{
\S4method{seqinfo}{RangeBasedTrack}(x, new2old = NULL, pruning.mode = c("error", "coarse", "fine", "tidy")) <- value

\S4method{seqinfo}{RangeBasedTrack}(x)

\S4method{seqlevelsInUse}{RangeBasedTrack}(x)

\S4method{seqinfo}{TnTBoard}(x)

\S4method{seqinfo}{CompositeTrack}(x)

\S4method{seqinfo}{CompositeTrack}(x, new2old = NULL, pruning.mode = c("error", "coarse", "fine", "tidy")) <- value

\S4method{seqlevelsInUse}{CompositeTrack}(x)
}
\arguments{
\item{x}{A TnTTrack or TnTBoard object.}

\item{new2old, pruning.mode, value}{Passed to seqinfo method for GenomicRanges.}
}
\value{
\code{seqinfo} returns a SeqInfo object.
}
\description{
Seqinfo of TnTTrack and TnTBoard
}
\examples{
btrack1 <- BlockTrack(GRanges("chr1", IRanges(1, 123)))
btrack2 <- BlockTrack(GRanges("chr2", IRanges(3, 599)))
ctrack <- merge(btrack1, btrack2)
board <- TnTBoard(list(btrack1, btrack2))

seqinfo(btrack1)
seqinfo(btrack2)
seqinfo(ctrack)
seqinfo(board)
}
