% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{generateRandomPaths}
\alias{generateRandomPaths}
\title{Produce random paths modeled on a given path}
\usage{
generateRandomPaths(
  path,
  from = 1,
  to = nrow(path),
  d = ncol(path),
  randomizationParams,
  N
)
}
\arguments{
\item{path}{- This is an mxn dimensional matrix. Each row is
considered a point.}

\item{from}{- The starting place along the path which will be
treated as the center of the sphere.  This defaults to 1.}

\item{to}{- The end point of the path.  This defaults to
nrow(path).}

\item{d}{- The dimension under consideration.  This defaults to
ncol(path)}

\item{randomizationParams}{- A character vector controling the
randomization method used.  It's first entry must be either
'byPermutation' or 'bySteps'  See the vignette for further
details.}

\item{N}{- The number of random paths required.}
}
\value{
This function returns a list of random paths.  Each path is
    a matrix.
}
\description{
This function takes a path and produces N random paths of the same
dimension and length based on it.  This can be done either by
permuting the entries in path or by taking steps from the initial
point of path.  Exact behaviour is controlled by
randomizationParams.
}
\examples{
randomizationParams = c('byPermutation','permuteWithinColumns')
randomPaths = generateRandomPaths(crooked_path,from=6,to=nrow(crooked_path),
              d=ncol(crooked_path),randomizationParams=randomizationParams,
              N=10)
}
