% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClass.R
\name{TreeSummarizedExperiment-constructor}
\alias{TreeSummarizedExperiment-constructor}
\alias{TreeSummarizedExperiment}
\title{Construct a TreeSummarizedExperiment object}
\usage{
TreeSummarizedExperiment(
  ...,
  rowTree = NULL,
  colTree = NULL,
  rowNodeLab = NULL,
  colNodeLab = NULL,
  referenceSeq = NULL
)
}
\arguments{
\item{...}{Arguments passed to the \code{\link{SummarizedExperiment}} constructor to fill the slots of the base class.}

\item{rowTree}{A phylo object that provides hiearchical information of rows
of assay tables.}

\item{colTree}{A phylo object that provides hiearchical information of
columns of assay tables.}

\item{rowNodeLab}{A character string. It provides the labels of nodes that
the rows of \code{assays} tables corresponding to. If NULL (default), the
row names of the \code{assays} tables are used.}

\item{colNodeLab}{A character string. It provides the labels of nodes that
the columns of \code{assays} tables corresponding to. If NULL (default),
the column names of the \code{assays} tables are used.}

\item{referenceSeq}{A \code{DNAStringSet}/\code{DNAStringSetList} object or
some object coercible to a \code{DNAStringSet}/\code{DNAStringSetList}
object. See \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} for
more details.}
}
\value{
a TreeSummarizedExperiment object
}
\description{
\code{TreeSummarizedExperiment} constructs a TreeSummarizedExperiment object.
}
\details{
The output TreeSummarizedExperiment object has very similar
  structure as the
  \code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}. The
  differences are summarized be as below.
  \itemize{
  \item \strong{rowTree} A slot exists in \code{TreeSummarizedExperiment}
  but not in \code{SingleCellExperiment}. It stores the tree structure(s)
  that provide(s) hierarchical information of \code{assays} rows or columns
  or both.
  \item \strong{rowData} If a \code{phylo} object is available in the slot
  \code{treeData} to provide the hiearchical information about the rows of
  the \code{assays} table, the \code{rowData} would be a
  \code{\link{LinkDataFrame-class}} instead of
  \code{\link[S4Vectors:DataFrame-class]{DataFrame}}. The data on the right side of the
  vertical line provides the link information between the \code{assays} rows
  and the tree \code{phylo} object, and could be accessed via
  \code{linkData}; The data on the left side is the original \code{rowData}
  like \code{SingleCellExperiment} object.
  \item \strong{colData} Similar to the explanaition for \strong{rowData} as
  above.
 }
 More details about the \code{LinkDataFrame} in the \code{rowData} or
 \code{colData}.
 \itemize{
 \item nodeLab The labels of nodes on the tree.
 \item nodeLab\_alias The alias of node labels on the tree.
 \item nodeNum The numbers of nodes on the tree.
 \item isLeaf It indicates whether the node is a leaf node or internal node.
 }
}
\examples{

data("tinyTree")

# the count table
count <- matrix(rpois(100, 50), nrow = 10)
rownames(count) <- c(tinyTree$tip.label)
colnames(count) <- paste("C_", 1:10, sep = "_")

# The sample information
sampC <- data.frame(condition = rep(c("control", "trt"), each = 5),
                    gender = sample(x = 1:2, size = 10, replace = TRUE))
rownames(sampC) <- colnames(count)

# build a TreeSummarizedExperiment object
tse <- TreeSummarizedExperiment(assays = list(count),
                                colData = sampC,
                                rowTree = tinyTree)

}
\seealso{
\code{\link[=TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
  \code{\link[=TreeSummarizedExperiment-accessor]{TreeSummarizedExperiment-accessor}}
  \code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}
}
\author{
Ruizhu HUANG
}
