% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundanceVDJ.R
\name{abundanceVDJ}
\alias{abundanceVDJ}
\alias{abundanceVDJ,clonoStats-method}
\title{Create an abundance graph for clonotype expansion}
\usage{
abundanceVDJ(x, ...)

\S4method{abundanceVDJ}{clonoStats}(x, annotate = 5, title = NULL)
}
\arguments{
\item{x}{A \code{matrix} created with \code{clonoStats}.}

\item{...}{additional arguments.}

\item{annotate}{An integer that specifies how many of the most abundant
clonotypes should be annotated on the plot.}

\item{title}{Character vector with an optional title. If FALSE, no title
is generated.}
}
\value{
Returns a \code{ggplot} plot with a dot plot that shows the
abundance of the clonotypes in each sample. The most abundant
clonotypes are annotated on the plot and ordered from most abundant
to least abundant.
}
\description{
\code{abundanceVDJ} creates a dot plot using ggplot that shows the
number of reads for each clonotype in each sample and labels the most
abundant clonotypes.
}
\examples{
data('contigs')
x <- clonoStats(contigs)
abundanceVDJ(x)

}
