% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-TransitionParam.R
\name{TransitionParam}
\alias{TransitionParam}
\alias{TransitionParam,missing-method}
\alias{TransitionParam,numeric-method}
\alias{show,TransitionParam-method}
\title{Constructor for TransitionParam class}
\usage{
TransitionParam(taup = 1e+10, taumax = 1 - 5e+06)

\S4method{show}{TransitionParam}(object)
}
\arguments{
\item{taup}{length-one numeric vector}

\item{taumax}{The maximum probability that the current state is the
same as the preceding state. See details}

\item{object}{a \code{TransitionParam} object}
}
\description{
Contains parameters for computing transition probabilities
}
\details{
Diagonal elements of the transition probability matrix are
computed as e^{-2*d/taup}, where d is the distance between markers
i and i-1 and \code{taup} is typically in the range of 1xe10.  This
probability is constrained to be no larger than \code{taumax}. The
probabilities on the off-diagonal elements are the same and are
subject to the constraint that the rows of the transition
probability matrix sum to 1.
}
\examples{
TransitionParam()
## higher values of taup make transitions between states less likely
TransitionParam(taup=1e12)
}
