% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleosome_enrichment.R
\name{nucleosomeEnrichment.Vmat}
\alias{nucleosomeEnrichment.Vmat}
\title{A function to compute nucleosome enrichment over a Vmat}
\usage{
\method{nucleosomeEnrichment}{Vmat}(x, background, plus1_nuc_only = FALSE, ...)
}
\arguments{
\item{x}{a computed Vmat. Should be un-normalized.}

\item{background}{a background Vmat. Should be un-normalized.}

\item{plus1_nuc_only}{Boolean, should compute nucleosome 
enrichment only for +1 nucleosome?}

\item{...}{additional parameters}
}
\value{
list
}
\description{
A function to compute nucleosome enrichment over a Vmat
}
\examples{
data(bam_test)
data(ce11_proms)
V <- plotVmat(
    bam_test,
    ce11_proms,
    normFun = '',
    return_Vmat = TRUE
)
V_bg <- plotVmat(
    bam_test,
    sampleGRanges(ce11_proms),
    normFun = '',
    return_Vmat = TRUE
)
n <- nucleosomeEnrichment(V, V_bg)
n$fisher_test
n$plot
}
