% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmat.R
\name{plotVmat.GRanges}
\alias{plotVmat.GRanges}
\title{A function to compute (and plot) a Vmat}
\usage{
\method{plotVmat}{GRanges}(
  x,
  granges,
  xlims = c(-250, 250),
  ylims = c(50, 300),
  normFun = "",
  s = 0.95,
  roll = 3,
  cores = 1,
  return_Vmat = FALSE,
  verbose = 1,
  ...
)
}
\arguments{
\item{x}{GRanges, paired-end fragments}

\item{granges}{GRanges, loci to map the fragments onto}

\item{xlims}{x limits of the computed Vmat}

\item{ylims}{y limits of the computed Vmat}

\item{normFun}{character. A Vmat should be scaled either by:
\itemize{
    \item 'libdepth+nloci', e.g. the library depth and the number of 
    loci used to compute the Vmat;
    \item zscore, if relative patterns of fragment density 
    are more important than density per se;
    \item Alternatively, the Vmat can be scaled to % ('pct'), to 
    a chosen quantile ('quantile') or to the max Vmat value ('max').
}}

\item{s}{A float indicating which quantile to use if 'quantile'
normalization is chosen}

\item{roll}{integer, to use as the window to smooth the Vmat rows 
by rolling mean.}

\item{cores}{Integer, number of threads to parallelize 
fragments subsetting}

\item{return_Vmat}{Boolean, should the function return the computed 
Vmat rather than the plot?}

\item{verbose}{Boolean}

\item{...}{additional parameters}
}
\value{
A Vmat ggplot
}
\description{
The plotVmat.GRanges() method computes and normalizes a Vmat 
before passing it to plotVmat.Vmat() method.
}
\examples{
data(bam_test)
data(ce11_proms)
V <- plotVmat(
    bam_test,
    ce11_proms,
    normFun = 'libdepth+nloci', 
    roll = 5
)
}
