% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_SMC}
\alias{plot_SMC}
\title{Plot results of the Stratification of a Mutational Catalogue}
\usage{
plot_SMC(
  number_of_strata,
  output_path,
  decomposition_method,
  number_of_sigs,
  name_list,
  exposures_strata_list,
  this_signatures_ind_df,
  this_subgroups_df,
  in_strata_order_ind,
  exposures_both_rel_df_list,
  cohort_method_flag,
  fig_width = 1200,
  fig_height = 900,
  fig_type = "png",
  in_label_orientation = "turn",
  this_sum_ind = NULL
)
}
\arguments{
\item{number_of_strata}{Number of strata as deduced from \code{link{SMC}}}

\item{output_path}{Path to file where the results are going to be stored.
If NULL, the results will be plotted to the running environment.}

\item{decomposition_method}{String for the filename of the generated 
barplot.}

\item{number_of_sigs}{Number of signatures}

\item{name_list}{Names of the contructed strata.}

\item{exposures_strata_list}{The list of \code{s} strata specific exposures
Hi, all are numerical data frames with \code{l} rows and \code{m} columns,
\code{l} being the number of signatures and \code{m} being the number of
samples}

\item{this_signatures_ind_df}{A data frame containing meta information about
the signatures}

\item{this_subgroups_df}{A data frame indicating which PID (patient or 
sample identifyier) belongs to which subgroup}

\item{in_strata_order_ind}{Index vector defining reordering of the strata}

\item{exposures_both_rel_df_list}{A list of \code{s} strata specific
cohortwide (i.e. averaged over cohort) normalized exposures}

\item{cohort_method_flag}{Either or several of
\code{c("all_PIDs","cohort","norm_PIDs")}, representing alternative ways 
to average over the cohort.}

\item{fig_width}{Width of the figure to be plotted}

\item{fig_height}{Height of the figure to be plotted}

\item{fig_type}{png or pdf}

\item{in_label_orientation}{Whether or not to turn the labels on the x-axis.}

\item{this_sum_ind}{Optional set of indices for reordering the PIDs}
}
\value{
The function doesn't return any value.
}
\description{
Plot a big composite figure with 3 columns: in the left column the per-PID
absolute exposures will be shown, in the middle column the per_PID relative
or normalized exposures will be shown, in the right column the cohort-wide
exposures are shown (averaged over PIDs).
}
\examples{
NULL

}
