% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_exposures}
\alias{plot_exposures}
\alias{plot_relative_exposures}
\title{Plot the exposures of a cohort}
\usage{
plot_exposures(
  in_exposures_df,
  in_signatures_ind_df,
  in_subgroups_df = NULL,
  in_sum_ind = NULL,
  in_subgroups.field = "subgroup",
  in_title = "",
  in_labels = TRUE,
  in_show_subgroups = TRUE,
  legend_height = 10
)

plot_relative_exposures(
  in_exposures_df,
  in_signatures_ind_df,
  in_subgroups_df,
  in_sum_ind = NULL,
  in_subgroups.field = "subgroup",
  in_title = "",
  in_labels = TRUE,
  in_show_subgroups = TRUE
)
}
\arguments{
\item{in_exposures_df}{Numerical data frame encoding the exposures \code{H},
i.e. which signature contributes how much to which PID (patient identifier
or sample).}

\item{in_signatures_ind_df}{A data frame containing meta information about
the signatures}

\item{in_subgroups_df}{A data frame indicating which PID (patient or sample
identifyier) belongs to which subgroup}

\item{in_sum_ind}{Index vector influencing the order in which the PIDs are
going to be displayed}

\item{in_subgroups.field}{String indicating the column name in
\code{in_subgroups_df} to take the subgroup information from.}

\item{in_title}{Title for the plot to be created.}

\item{in_labels}{Flag, if \code{TRUE} the PIDs are displayed on the x-axis}

\item{in_show_subgroups}{Flag, if \code{TRUE} then PIDs are grouped by
subgroups}

\item{legend_height}{How many signatures should be displayed in one column
together at most.}
}
\value{
The generated barplot - a ggplot2 plot
}
\description{
\code{plot_exposures}: The exposures \code{H}, determined by NMF or by
\code{\link{LCD}}, are displayed as a stacked barplot by calling \itemize{
\item \code{\link[ggplot2]{geom_bar}} and optionally \item
\code{\link[ggplot2]{geom_text}}. } The x-axis displays the PIDs (patient
identifier or sample), the y-axis the counts attributed to the different
signatures with their respective colours per PID. Is called by
\code{\link{plot_relative_exposures}}.

\code{plot_relative_exposures}: Plot the relative or normalized exposures of
a cohort. This function first normalizes its input and then sends the
normalized data to \code{\link{plot_exposures}}.
}
\examples{
 data(lymphoma_cohort_LCD_results)
 plot_exposures(lymphoma_Nature2013_COSMIC_cutoff_exposures_df,
                chosen_signatures_indices_df,
                COSMIC_subgroups_df)

 data(lymphoma_cohort_LCD_results)
 plot_relative_exposures(lymphoma_Nature2013_COSMIC_cutoff_exposures_df,
                         chosen_signatures_indices_df,
                         COSMIC_subgroups_df)

}
\seealso{
\code{\link{LCD}}

\code{\link[ggplot2]{geom_bar}}

\code{\link[ggplot2]{geom_text}}
}
