% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advGridMinChange.R
\name{advGridMinChange}
\alias{advGridMinChange}
\title{Grid search of min change adversarial attack. Tries each
combination on a cluster, given a list of genes and a list of modifications.}
\usage{
advGridMinChange(
  exprs,
  clusters,
  target,
  classifier,
  genes,
  modifications = list(c("perc1"), c("perc99")),
  returnFirstFound = FALSE,
  argForClassif = "data.frame",
  argForModif = "data.frame",
  verbose = FALSE,
  iamsure = FALSE
)
}
\arguments{
\item{exprs}{DelayedMatrix of numeric RNA expression, cells are rows and genes
are columns - or a SingleCellExperiment object, a matrix or a data.frame. By
default matrix and data.frame are converted to DelayedMatrix for memory
performance, see 'argForModif' argument for options.}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{target}{the name of the cluster to modify}

\item{classifier}{a classifier in the suitable format.
A classifier function should be formated as follow:
classifier = function(expr, clusters, target){
# Making the classification
c("cell type", score)
}
\code{score} should be numeric between 0 and 1, 1 being the highest confidance
into the cell type classification.
The matrix \code{expr} contains RNA expression values, the vector \code{clusters}
consists of the cluster IDs for each cell in \code{expr}, and \code{target} is the
ID of the cluster for which we want to have a classification.
The function returns a vector with the classification result, and a score.}

\item{genes}{the character vector of genes to study}

\item{modifications}{the list of the modifications to study}

\item{returnFirstFound}{set to TRUE to return result when a
the first misclassification is found}

\item{argForClassif}{the type of the first argument to feed to the
classifier function. 'data.frame' by default, can be 'SingleCellExperiment'
or 'DelayedMatrix'.}

\item{argForModif}{type of matrix during for the modification, 'data.frame'
by default. Can be 'DelayedMatrix', which needs less memory but is slower.}

\item{verbose}{logical, set to TRUE to activate verbose mode}

\item{iamsure}{logical, prevents from expansive calculations
when \code{genes} list is too long, set to \code{TRUE} to run anyway.}
}
\value{
DataFrame results of the classification of all the grid combinations
}
\description{
Grid search of min change adversarial attack. Tries each
combination on a cluster, given a list of genes and a list of modifications.
}
\details{
This function aims to find the shortest combination of genes
allowing to make a min change attack. It will test every possible combination
for a given gene list. This function can take a long time to run, and we
recommand to use the random walk search advRandWalkMinChange function instead
for lists above 10 genes.

You can specify a list of modifications as so, each item of the list should be 1 or 2 length size.
The 1 length vector must contain the prerecorded modifications, 'perc1' or 'perc99'.
The 2 length vector must have as first item:
\itemize{
\item 'fixed', in this case the second item should be the value to be
replaced by.
\item 'full_row_fct', 'target_row_fct', 'target_matrix_fct' or
'full_matrix_fct'. In this case the second item should be a function.
Let's say we want to analysis the susceptibility to min change attack
for 3 modifications: "perc1", the modification of each value of the
cluster by 1000, and a custom modification stored inside a function myFct.
Then the 'modification' parameter should be:
my_modifications = list(c("perc1"),
c("fixed", 1000),
c("full_matrix_fct", myFct))
}
}
\examples{
library(DelayedArray)

MyClassifier <- function(expr, clusters, target) {
   c("T cell", 0.9)
}
rna_expression <- DelayedArray(data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
     CD8B=c(2,2,3,3)))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","B cell","T cell","T cell")

advGridMinChange(rna_expression, clusters_id, "T cell",
 MyClassifier, genes=genes,
 modifications = list(c("perc1"), c("perc99")))

myModif = function(x, y){
   return(sample(1:10,1))
}

my_modifications = list(c("perc1"),
                        c("fixed", 1000),
                        c("full_matrix_fct", myModif))
advGridMinChange(rna_expression, clusters_id, "T cell",
 MyClassifier, genes=genes, modifications = my_modifications)

}
