% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advMaxChange.R
\name{advMaxChange}
\alias{advMaxChange}
\title{Find a max change adversarial attack. It finds the longer
list of genes you can modify on a cluster without changing its
classification.}
\usage{
advMaxChange(
  exprs,
  clusters,
  target,
  classifier,
  exclGenes = c(),
  genes = c(),
  advMethod = "perc99",
  advFixedValue = 3,
  advFct = NULL,
  maxSplitSize = 1,
  argForClassif = "data.frame",
  argForModif = "data.frame",
  slot = NULL,
  verbose = FALSE
)
}
\arguments{
\item{exprs}{DelayedMatrix of numeric RNA expression, cells are rows and genes
are columns - or a SingleCellExperiment object, a matrix or a data.frame. By default,
these are converted to a data.frame to increase speed performance during modifications.
However, this conversion can consume a significant amount of memory, see 'argForModif'
argument for options.}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{target}{the name of the cluster to modify}

\item{classifier}{a classifier in the suitable format.
A classifier function should be formated as follow:
classifier = function(expr, clusters, target){
# Making the classification
c("cell type", score)
}
\code{score} should be numeric between 0 and 1, 1 being the highest confidance
into the cell type classification.
The matrix \code{expr} contains RNA expression values, the vector \code{clusters}
consists of the cluster IDs for each cell in \code{expr}, and \code{target} is the
ID of the cluster for which we want to have a classification.
The function returns a vector with the classification result, and a score.}

\item{exclGenes}{a list of genes to exclude from the analysis}

\item{genes}{a list of genes in case you want to limit the
attack on a subset of genes}

\item{advMethod}{the name of the method to use}

\item{advFixedValue}{the numeric value to use in case of
advMethod=\code{fixed}}

\item{advFct}{the function to use in case advMethod
belongs to the following list: \code{full_row_fct}, \code{target_row_fct},
\code{target_matrix_fct}, \code{full_matrix_fct}}

\item{maxSplitSize}{max size of dichotomic slices.}

\item{argForClassif}{the type of the first argument to feed to the
classifier function. 'data.frame' by default, can be 'SingleCellExperiment'
or 'DelayedMatrix'.}

\item{argForModif}{type of matrix during for the modification, 'data.frame'
by default. Can be 'DelayedMatrix', which needs less memory but is slower.}

\item{verbose}{logical, set to TRUE to activate verbose mode}
}
\value{
a character vector of genes you can modify on a cluster without
modifying its classification
}
\description{
Find a max change adversarial attack. It finds the longer
list of genes you can modify on a cluster without changing its
classification.
}
\details{
This function aims to get the largest part of the genes
that can be modified without altering the classification,
considering a given modification. You can refer to the
'advModifications' function documentation to more details on how
to define a modification.
The search is made by a dichotomic process, on a reccursive function.
At each iteration the function splits the genes in two groups. It
proceeds to the modification of the RNA gene value of the first group,
makes its classification. Then three possible scenarios:
\itemize{
\item the classification is the same as the target cluster. We concat
the genes list to the previous one, make the classification, and it still
gives same classification. Then we return the genes list.
\item the classification is the same as the target cluster. We concat
the genes list to the previous one, make the classification, and it
gives a different classification. This happens often, you can modify
the gene A with a classification of T cell, or modify the gene B with a
classification of T cell, but modifying A and B returns another
classification. In this case we split the genes list in two and try again.
\item the classification is not the same as the target cluster. In this case we
split the genes list in two and try again.
The iteration process stops when the length of the genes list is lower
than the value of the 'maxSplitSize' argument. So you should set it to 1
to have the maximum number of genes for the max change attack. This function
is used by the 'overMaxChange' function with a default argument value of 100
to increase speed, and still returns significant results.
}
}
\examples{
library(DelayedArray)

MyClassifier <- function(expr, clusters, target) {
   c("T cell", 0.9)
}
rna_expression <- DelayedArray(data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
     CD8B=c(2,2,3,3)))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","B cell","T cell","T cell")

advMaxChange(rna_expression, clusters_id,
"T cell", MyClassifier, advMethod="perc99")
}
