% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advSingleGene.R
\name{advSingleGene}
\alias{advSingleGene}
\title{Find a one gene min change adversarial attack list. A one gene min change
adversarial attack  refers to the modification of a single gene
within a cluster, leading to a change in its classification. The function
returns a list of genes/new classification.}
\usage{
advSingleGene(
  exprs,
  clusters,
  target,
  classifier,
  exclGenes = c(),
  genes = c(),
  advMethod = "perc99",
  advFixedValue = 3,
  advFct = NULL,
  firstDichot = 100,
  maxSplitSize = 1,
  returnFirstFound = FALSE,
  changeType = "any",
  argForClassif = "data.frame",
  argForModif = "data.frame",
  slot = NULL,
  verbose = FALSE
)
}
\arguments{
\item{exprs}{DelayedMatrix of numeric RNA expression, cells are rows and genes
are columns - or a SingleCellExperiment object, a matrix or a data.frame. By default,
these are converted to a data.frame to increase speed performance during modifications.
However, this conversion can consume a significant amount of memory, see 'argForModif'
argument for options.}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{target}{the name of the cluster to modify}

\item{classifier}{a classifier in the suitable format.
A classifier function should be formated as follow:
classifier = function(expr, clusters, target){
# Making the classification
c("cell type", score)
}
\code{score} should be numeric between 0 and 1, 1 being the highest confidance
into the cell type classification.
The matrix \code{expr} contains RNA expression values, the vector \code{clusters}
consists of the cluster IDs for each cell in \code{expr}, and \code{target} is the
ID of the cluster for which we want to have a classification.
The function returns a vector with the classification result, and a score.}

\item{exclGenes}{a character vector of genes to exclude from the analysis}

\item{genes}{a character vector of genes in case you want to limit the
attack on a subset of genes}

\item{advMethod}{the name of the method to use}

\item{advFixedValue}{the numeric value to use in case of
advMethod=\code{fixed}}

\item{advFct}{the function to use in case advMethod
belongs to the following list: \code{full_row_fct}, \code{target_row_fct},
\code{target_matrix_fct}, \code{full_matrix_fct}}

\item{firstDichot}{the initial number of slices before
the dichotomic search}

\item{maxSplitSize}{max size of dichotomic slices}

\item{returnFirstFound}{set to TRUE to return result when a
the first misclassification is found}

\item{changeType}{\code{any} consider each misclassification,
\code{not_na} consider each misclassification but NA.}

\item{argForClassif}{the type of the first argument to feed to the
classifier function. 'data.frame' by default, can be 'SingleCellExperiment'
or 'DelayedMatrix'.}

\item{argForModif}{type of matrix during for the modification, 'data.frame'
by default. Can be 'DelayedMatrix', which needs less memory but is slower.}

\item{verbose}{logical, set to TRUE to activate verbose mode}
}
\value{
a list of genes/new classification tuples
}
\description{
Find a one gene min change adversarial attack list. A one gene min change
adversarial attack  refers to the modification of a single gene
within a cluster, leading to a change in its classification. The function
returns a list of genes/new classification.
}
\details{
This function aims to get all genes that when modified individually
can lead to a misclassification. You can refer to the
'advModifications' function documentation to more details on how
to define a modification.
The function is made as a two step parameter search. The first step is to
split the genes in 'firstDichot' sets, 100 by default. Then each set is
studied by a dichotomic process in a recursive function.
The aim of sarting by a high value of sets, instead of starting directly by
the dichotomic research is to avoid the following scenario: we modify 5000
genes, the modification of one gene conpensates the modification of another.
The classification remains unchanged, whereas there is a one gene
classification modifying inside the 5000.
The dichotomic process runs as follow. The function receives a list of
genes, make the modification of the whole list and make the classification.
Three scenarios possible:
\itemize{
\item the classification remains the same as the target cluster. The function
returns, and the dichotomic process continues.
\item the classification is changed. There is only one gene in the list, the
function returns the gene and the new classification.
\item the classification is changed. There is more than one gene in the list,
the genes list is split in two, and the dichotomic process continues.
}
}
\examples{
library(DelayedArray)

MyClassifier <- function(expr, clusters, target) {
   c("B cell", 0.9)
}
rna_expression <- DelayedArray(data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
     CD8B=c(2,2,3,3)))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","B cell","T cell","T cell")

advSingleGene(rna_expression, clusters_id,
"T cell", MyClassifier, advMethod="perc99")
}
