% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stageSpatialImage.R
\name{stageSpatialImage}
\alias{stageSpatialImage}
\alias{stageObject,VirtualSpatialImage-method}
\alias{stageObject,StoredSpatialImage-method}
\alias{stageObject,RemoteSpatialImage-method}
\title{Stage images for upload}
\usage{
\S4method{stageObject}{VirtualSpatialImage}(x, dir, path, child = FALSE, ...)

\S4method{stageObject}{StoredSpatialImage}(x, dir, path, child = FALSE, ...)

\S4method{stageObject}{RemoteSpatialImage}(x, dir, path, child = FALSE, ...)
}
\arguments{
\item{x}{A \linkS4class{SpatialImage} object.}

\item{dir}{String containing a path to a directory.}

\item{path}{String containing a relative path inside a directory.}

\item{child}{Logical scalar indicating whether \code{x} is a child of another object.}

\item{...}{Further arguments, ignored.}
}
\value{
An image file is created at \code{file.path(dir, path)}, possibly after appending an appropriate file extension.

The return value should be a named list containing at least:
\itemize{
\item \code{$schema}, a string specifying the schema to use to validate the metadata.
This may have a \code{package} attribute to specify the package where the schema lives (in its \code{inst/schemas} directory).
\item \code{path}, a string containing the path to the file containing the assay contents.
This should start with the input \code{path} but can be followed by any necessary file extensions.
\item \code{child}, whether this is a child resource of a larger object.
}
Other fields can be provided and will be included in the metadata, provided that they are recognized by the specified schema.
}
\description{
These methods are deprecated and are only documented here for back-compatibility purposes.
}
\details{
Each of the different methods will take advantage of any existing files to avoid an actual save.
For example, the \linkS4class{RemoteSpatialImage} method will download the file directly to \code{path},
while the \linkS4class{StoredSpatialImage} method will create a link or copy the file.
The \linkS4class{SpatialImage} method will fall back to saving the raster directly as a PNG.
}
\examples{
example(read10xVisium, echo=FALSE)
(img <- imgData(spe)$data[[1]])

# Doing a local run: 
tmp <- tempfile()
dir.create(tmp)
stageObject(img, tmp, "whee")

# Forcing a re-save:
Y <- as(img, "LoadedSpatialImage")
stageObject(Y, tmp, "foo")

}
\author{
Aaron Lun
}
