% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_alignment.R
\name{is_hdr_strict}
\alias{is_hdr_strict}
\title{Figure out which reads conform to the HDR using the donor.}
\usage{
is_hdr_strict(aln, cfgT, scoring_matrix, gap_opening = 25, gap_extension = 0)
}
\arguments{
\item{aln}{(data.table) This are events that contain already consensus column,
they are also shifted and normalized.}

\item{cfgT}{(data.table) Config data.table with columns for amplicon and donor.}

\item{scoring_matrix}{(scoring matrix)}

\item{gap_opening}{(integer)}

\item{gap_extension}{(integer)}
}
\value{
(aln) same as aln on entry, but readType is updated to TRUE when read is recognized as HDR
}
\description{
This is strict detection as compared to `is_hdr` which was designed to be
less specific and allow for all kinds of donors. This method requires that
you have exactly the same events (mismatches, insertions, deletions) as the difference
between amplicon and donor sequences. It ignores everything else, so other mismatches and small
indels etc. as noise are allowed here for valid HDR.
}
