% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_summary_bar_density.R
\name{filter_summary_bar_density}
\alias{filter_summary_bar_density}
\title{Data visualization by bar plot / density plot}
\usage{
filter_summary_bar_density(
  MAE,
  samples_discard = NULL,
  filter_type,
  sample_condition
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{samples_discard}{The list of samples to filter}

\item{filter_type}{Either 'By Microbes' or 'By Metadata'}

\item{sample_condition}{Which condition to check e.g. 'SEX'}
}
\value{
A plotly object
}
\description{
Data visualization by bar plot / density plot
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
result <- filter_summary_bar_density(toy_data,
  samples_discard = c("subject_2", "subject_4"),
  filter_type = "By Metadata",
  sample_condition = "SEX"
)
result

}
