% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabu_heatmap.R
\name{relabu_heatmap}
\alias{relabu_heatmap}
\title{Plot heatmap of sample level counts in logcpm}
\usage{
relabu_heatmap(
  MAE,
  tax_level,
  sort_by = c("nosort", "conditions", "organisms", "alphabetically"),
  sample_conditions = c(),
  isolate_organisms = c(),
  isolate_samples = c(),
  discard_samples = c(),
  log_cpm = TRUE
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{sort_by}{Sort bars by one of 
c('nosort', 'conditions', 'organisms', 'alphabetically')}

\item{sample_conditions}{Plot conditions e.g. c('SEX', 'AGE')}

\item{isolate_organisms}{Isolate specific organisms e.g. c('Hepacivirus')}

\item{isolate_samples}{Isolate specific samples e.g. c('SAM_01', 'SAM_02')}

\item{discard_samples}{Discard specific samples e.g. c('SAM_01', 'SAM_02')}

\item{log_cpm}{Convert counts to logcpm}
}
\value{
A plotly object
}
\description{
Plot heatmap of sample level counts in logcpm
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
p <- relabu_heatmap(toy_data,
  tax_level = "genus",
  sort_by = "conditions",
  sample_conditions = c("SEX", "AGE")
)
p

}
