% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/ERVmap.R
\docType{class}
\name{ERVmapParam-class}
\alias{ERVmapParam-class}
\alias{ERVmapParam}
\alias{show,ERVmapParam-method}
\title{ERVmap parameter class}
\usage{
ERVmapParam(
  bfl,
  teFeatures,
  aggregateby = character(0),
  ovMode = "ovUnion",
  geneFeatures = NULL,
  singleEnd = TRUE,
  ignoreStrand = TRUE,
  strandMode = 1L,
  fragments = !singleEnd,
  maxMismatchRate = 0.02,
  suboptimalAlignmentTag = "auto",
  suboptimalAlignmentCutoff = 5,
  geneCountMode = "all",
  verbose = TRUE
)

\S4method{show}{ERVmapParam}(object)
}
\arguments{
\item{bfl}{A \code{BamFile} or \code{BamFileList} object, or a character
string vector of BAM filenames.}

\item{teFeatures}{A \code{GRanges} or \code{GRangesList} object with the
transposable element (TE) annotated features to be quantified. Elements in 
this object should have names, which are used as a grouping factor for 
genomic ranges forming a common locus, unless other metadata column names 
are specified in the \code{aggregateby} parameter.}

\item{aggregateby}{Character vector with column names in the annotation
to be used to aggregate quantifications. By default, this is an empty
vector, which means that the names of the input \code{GRanges} or 
\code{GRangesList} object given in the \code{teFeatures} parameter are used
to aggregate quantifications.}

\item{ovMode}{Character vector indicating the overlapping mode. Available
options are: "ovUnion" (default) and "ovIntersectionStrict",
which implement the corresponding methods from HTSeq
(\url{https://htseq.readthedocs.io/en/release_0.11.1/count.html}).
Ambiguous alignments (alignments overlapping > 1 feature) are addressed
as in the original ERVmap algorithm.}

\item{geneFeatures}{(Default NULL) A \code{GRanges} or 
\code{GRangesList} object with the
gene annotated features to be quantified. Overlaps with unique reads are 
first tallied with respect to these gene features. Elements should have 
names indicating the gene name/id. In case that \code{geneFeatures} 
is a \code{GRanges} and contains
a metadata column named \code{type}, only the elements with 
\code{type} = \code{exon} are considered for the analysis. Then, exon
counts are summarized to the gene level. If NULL, gene expression is
not quantified.}

\item{singleEnd}{(Default TRUE) Logical value indicating if reads are single
(\code{TRUE}) or paired-end (\code{FALSE}).}

\item{ignoreStrand}{(Default TRUE) A logical which defines if the strand
should be taken into consideration when computing the overlap between reads
and annotated features. When \code{ignore_strand = FALSE}, an aligned read
is considered to be overlapping an annotated feature as long as they
have a non-empty intersecting genomic range on the same strand, while when
\code{ignoreStrand = TRUE} the strand is not considered.}

\item{strandMode}{(Default 1) Numeric vector which can take values 0, 1 or 
2.
  The strand mode is a per-object switch on
  \code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
  objects that controls the behavior of the strand getter. See
  \code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
  class for further detail. If \code{singleEnd = TRUE}, then
  \code{strandMode} is ignored.}

\item{fragments}{(Default not \code{singleEnd}) A logical; applied to
paired-end data only. When \code{fragments=TRUE}, the read-counting
method in the original ERVmap algorithm is applied: each mate of a
paired-end read is counted (including ambiguous and not properly paired 
reads). When
\code{fragments=FALSE}, if the two mates of a paired-end read map to the
same element, they are counted as a single hit and singletons, reads with
unmapped pairs and other ambiguous or not properly paired fragments are 
not counted (see "Pairing criteria" in 
\code{\link[GenomicAlignments]{readGAlignments}()}).}

\item{maxMismatchRate}{(Default 0.02) Numeric value storing the maximum
mismatch rate employed by the ERVmap algorithm to discard aligned reads
whose rate of sum of hard and soft clipping or whose rate of the edit
distance over the genome reference to the length of the read is above this
threshold.}

\item{suboptimalAlignmentTag}{(Default "auto") Character string storing the
tag name in the BAM files that stores the suboptimal alignment score used in
the third filter of ERVmap; see
\href{https://doi.org/10.1073/pnas.1814589115}{Tokuyama et al. (2018)}.
The default, \code{suboptimalAlignmentTag="auto"}, first extracts the name
of the read mapper software from one or more BAM files. If BAM files were
generated by BWA, the suboptimal alignment scores are obtained from a tag
called \code{XS}. For other read mappers, the suboptimal alignment score
is considered to be missing since, except from BWA, no other aligner
provides a tag with suboptimal alignment scores. In this case, the available
secondary alignments are used to implement an analogous approach to that
of the third ERVmap filter. When \code{suboptimalAlignmentTag="none"}, it
also performs the latter approach even when the tag \code{XS} is available.
When this parameter is different from \code{"auto"} and \code{"none"}, a tag
with the given name is used to extract the suboptimal alignment score.}

\item{suboptimalAlignmentCutoff}{(Default 5) Numeric value storing the
cutoff above which the difference between the alignment score and the
suboptimal alignment score is considered sufficiently large to retain the
alignment. When this value is set to \code{NA}, the filtering step based on
suboptimal alignment scores is skipped.}

\item{geneCountMode}{(Default \code{"all"}) Character string indicating if 
the ERVmap read filters applied to quantify TEs expression should also be 
applied when quantifying gene expression (\code{"ervmap"}) or not 
(\code{"all"}), in which case all primary alignments mapping to genes are 
counted.}

\item{verbose}{(Default \code{TRUE}) Logical value indicating whether to
report progress.}

\item{object}{A \linkS4class{ERVmapParam} object.}
}
\value{
A \linkS4class{ERVmapParam} object.
}
\description{
This is a class for storing parameters provided to the ERVmap algorithm.
It is a subclass of the [`QuantifyParam`] class.

Build an object of the class \code{ERVmapParam}
}
\details{
This is the constructor function for objects of the class
\code{ERVmapParam-class}. This type of object is the input to the
function \code{\link{qtex}()} for quantifying expression of transposable
elements using the ERVmap method
\href{https://doi.org/10.1073/pnas.1814589115}{Tokuyama et al. (2018)}. The
ERVmap algorithm processes reads following conservative filtering criteria
to provide reliable raw count data for each TE.
}
\section{Slots}{

\describe{
\item{\code{readMapper}}{The name of the software used to align reads, obtained from
the BAM file header.}

\item{\code{singleEnd}}{(Default FALSE) Logical value indicating if reads are single
(\code{TRUE}) or paired-end (\code{FALSE}).}

\item{\code{strandMode}}{(Default 1) Numeric vector which can take values 0, 1 or 2.
The strand mode is a per-object switch on
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
objects that controls the behavior of the strand getter. See
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail. If \code{singleEnd = TRUE}, then
\code{strandMode} #'   is ignored.}

\item{\code{ignoreStrand}}{(Default TRUE) A logical which defines if the strand
should be taken into consideration when computing the overlap between reads
and TEs in the annotations. When \code{ignore_strand = FALSE}, only those
reads which overlap the TE and are on the same strand are counted. On the
contrary, when \code{ignore_strand = TRUE}, any read overlapping an element
in \code{teFeatures} is counted regardless of the strand.}

\item{\code{fragments}}{(Default not \code{singleEnd}) A logical; applied to
paired-end data only. When \code{fragments=TRUE}, the read-counting
method in the original ERVmap algorithm is applied: each mate of a
paired-end read is counted (including ambiguous and not properly paired 
reads). When
\code{fragments=FALSE}, if the two mates of a paired-end read map to the
same element, they are counted as a single hit and singletons, reads with
unmapped pairs and other ambiguous or not properly paired fragments are 
not counted (see "Pairing criteria" in 
\code{\link[GenomicAlignments]{readGAlignments}()}).}

\item{\code{maxMismatchRate}}{(Default 0.02) Numeric value storing the maximum
mismatch rate employed by the ERVmap algorithm to discard aligned reads
whose rate of sum of hard and soft clipping, or of the edit distance over
the genome reference, to the length of the read is above this threshold.}

\item{\code{suboptimalAlignmentTag}}{(Default "auto") Character string storing the
tag name in the BAM files that stores the suboptimal alignment score used in
the third filter of ERVmap; see Tokuyama et al. (2018). The default,
\code{suboptimalAlignmentTag="auto"}, assumes that either the BAM files were
generated by BWA and include a tag called \code{XS} that stores the
suboptimal alignment score or, if the \code{XS} tag is not available, then
it uses the available secondary alignments to implement an analogous
approach to that of the third ERVmap filter. When
\code{suboptimalAlignmentTag="none"}, it also performs the latter approach
even when the tag \code{XS} is available.
When this parameter is different from \code{"auto"} and \code{"none"}, a tag
with the given name is used to extract the suboptimal alignment score.
The absence of that tag will prompt an error.}

\item{\code{suboptimalAlignmentCutoff}}{(Default 5) Numeric value storing the cutoff
above which the difference between the alignment score and the suboptimal
alignment score is considered sufficiently large to retain the alignment.
When this value is set to \code{NA}, then the filtering step based on
suboptimal alignment scores is skipped.}

\item{\code{geneCountMode}}{(Default "all") Character string indicating if the
ERVmap read filters applied to quantify TEs expression should also be
applied when quantifying gene expression ("ervmap") or not ("all"), in which
case all primary alignments mapping to genes are counted.}
}}

\examples{
bamfiles <- list.files(system.file("extdata", package="atena"),
                       pattern="*.bam", full.names=TRUE)
\dontrun{
rmskat <- annotaTEs(genome="dm6", parsefun=rmskatenaparser,
                    strict=FALSE, insert=500)
rmskLTR <- getLTRs(rmskat, relLength=0.8,
                   fullLength=TRUE,
                   partial=TRUE,
                   otherLTR=TRUE)
}

## DO NOT TYPE THIS INSTRUCTION, WHICH JUST LOADS A PRE-COMPUTED ANNOTATION
## YOU SHOULD USE THE INSTRUCTIONS ABOVE TO FETCH ANNOTATIONS
rmskLTR <- readRDS(system.file("extdata", "rmskatLTRrlen80flenpartoth.rds",
                               package="atena"))

## build a parameter object for ERVmap
empar <- ERVmapParam(bamfiles,
                     teFeatures=rmskLTR,
                     singleEnd=TRUE,
                     ignoreStrand=TRUE,
                     suboptimalAlignmentCutoff=NA)
empar

}
\references{
Tokuyama M et al. ERVmap analysis reveals genome-wide transcription of human
endogenous retroviruses. PNAS. 2018;115(50):12565-12572. DOI:
\url{https://doi.org/10.1073/pnas.1814589115}

Tokuyama M et al. ERVmap analysis reveals genome-wide transcription of human
endogenous retroviruses. PNAS. 2018;115(50):12565-12572. DOI:
\url{https://doi.org/10.1073/pnas.1814589115}
}
