% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/TEtranscripts.R
\docType{class}
\name{TEtranscriptsParam-class}
\alias{TEtranscriptsParam-class}
\alias{TEtranscriptsParam}
\alias{show,TEtranscriptsParam-method}
\title{TEtranscripts parameter class}
\usage{
TEtranscriptsParam(
  bfl,
  teFeatures,
  aggregateby = character(0),
  ovMode = "ovUnion",
  geneFeatures = NULL,
  singleEnd = TRUE,
  ignoreStrand = FALSE,
  strandMode = 1L,
  fragments = TRUE,
  tolerance = 1e-04,
  maxIter = 100L,
  verbose = TRUE
)

\S4method{show}{TEtranscriptsParam}(object)
}
\arguments{
\item{bfl}{a character string vector of BAM file names.}

\item{teFeatures}{A \code{GRanges} or \code{GRangesList} object with the
TE annotated features to be quantified. Elements in this object should have
names, which are used as a grouping factor for genomic ranges forming a
common locus, unless other metadata column names are specified in the
\code{aggregateby} parameter.}

\item{aggregateby}{Character vector with column names from the annotation
to be used to aggregate quantifications. By default, this is an empty
vector, which means that the names of the input \code{GRanges} or
\code{GRangesList} object given in the \code{teFeatures} parameter are used
to aggregate quantifications.}

\item{ovMode}{Character vector indicating the overlapping mode. Available
options are: "ovUnion" (default) and "ovIntersectionStrict",
which implement the corresponding methods from HTSeq
(\url{https://htseq.readthedocs.io/en/release_0.11.1/count.html}).
Ambiguous alignments (alignments overlapping > 1 feature) are addressed
as in the original TEtranscripts method.}

\item{geneFeatures}{(Default NULL) A \code{GRanges} or 
\code{GRangesList} object with the
gene annotated features to be quantified. Following the TEtranscripts
algorithm, overlaps with unique reads are first tallied with respect to
these gene features. Elements should have names indicating the gene name/id.
In case that \code{geneFeatures} is a \code{GRanges} and contains a 
metadata column named
\code{type}, only the elements with \code{type} = \code{exon} are considered
for the analysis. Then, exon counts are summarized to the gene level. If
NULL, gene expression is not quantified.}

\item{singleEnd}{(Default TRUE) Logical value indicating if reads are single
(\code{TRUE}) or paired-end (\code{FALSE}).}

\item{ignoreStrand}{(Default FALSE) Logical value that defines if the strand
should be taken into consideration when computing the overlap between reads
and annotated features. When \code{ignoreStrand = FALSE}, an aligned read
is considered to be overlapping an annotated feature as long as they
have a non-empty intersecting genomic range on the same strand, while when
\code{ignoreStrand = TRUE} the strand is not considered.}

\item{strandMode}{(Default 1) Numeric vector which can take values 0, 1 or
2.
The strand mode is a per-object switch on
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
objects that controls the behavior of the strand getter. See
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail. If \code{singleEnd = TRUE}, then \code{strandMode}
is ignored.}

\item{fragments}{(Default TRUE) Logical value applied to paired-end data
only. In both cases (\code{fragments=FALSE} and \code{fragments=TRUE}), the
read-counting method discards not properly paired reads. Moreover,
when \code{fragments=FALSE}, only non-ambiguous properly paired reads are
counted. When \code{fragments=TRUE}, ambiguous reads are also counted 
(see "Pairing criteria" in \code{\link[GenomicAlignments]{readGAlignments}()}). 
\code{fragments=TRUE} is equivalent to
the behavior of the TEtranscripts algorithm. For further details see
\code{\link[GenomicAlignments]{summarizeOverlaps}()}.}

\item{tolerance}{A positive numeric scalar storing the minimum tolerance
above which the SQUAREM algorithm (Du and Varadhan, 2020) keeps iterating.
Default is \code{1e-4} and this value is passed to the \code{tol} parameter
of the \code{\link[SQUAREM]{squarem}()} function.}

\item{maxIter}{A positive integer scalar storing the maximum number of
iterations of the SQUAREM algorithm (Du and Varadhan, 2020). Default
is 100 and this value is passed to the \code{maxiter} parameter of the
\code{\link[SQUAREM]{squarem}()} function.}

\item{verbose}{(Default \code{TRUE}) Logical value indicating whether to
report progress.}

\item{object}{A \linkS4class{TEtranscriptsParam} object.}
}
\value{
A \linkS4class{TEtranscriptsParam} object.
}
\description{
This is a class for storing parameters provided to the TEtranscripts
algorithm. It is a subclass of the [`QuantifyParam`].

Build an object of the class \code{TEtranscriptsParam}
}
\details{
This is the constructor function for objects of the class
\code{TEtranscriptsParam-class}. This type of object is the input to the
function \code{\link{qtex}()} for quantifying expression of transposable
elements using the TEtranscripts method
\href{https://doi.org/10.1093/bioinformatics/btv422}{Jin et al. (2015)}. The
TEtranscripts algorithm quantifies TE expression by using an EM algorithm
to optimally distribute ambiguously mapped reads.
}
\section{Slots}{

\describe{
\item{\code{singleEnd}}{(Default FALSE) Logical value indicating if reads are single
(\code{TRUE}) or paired-end (\code{FALSE}).}

\item{\code{ignoreStrand}}{(Default FALSE) A logical which defines if the strand
should be taken into consideration when computing the overlap between reads
and annotated features. When \code{ignoreStrand = FALSE}, an aligned read
will be considered to be overlapping an annotated feature as long as they
have a non-empty intersecting genomic ranges on the same strand, while when
\code{ignoreStrand = TRUE} the strand will not be considered.}

\item{\code{strandMode}}{(Default 1) Numeric vector which can take values 0, 1 or 2.
The strand mode is a per-object switch on
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
objects that controls the behavior of the strand getter. See
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail. If \code{singleEnd = TRUE}, then use either
\code{strandMode = NULL} or do not specify the \code{strandMode} parameter.}

\item{\code{fragments}}{(Default TRUE) A logical; applied to paired-end data only.
In both cases (\code{fragments=FALSE} and \code{fragments=TRUE}), the
read-counting method discards not properly paired reads. Moreover,
when \code{fragments=FALSE}, only non-ambiguous properly paired reads are
counted. When \code{fragments=TRUE}, ambiguous reads are also counted 
(see "Pairing criteria" in \code{\link[GenomicAlignments]{readGAlignments}()}). 
\code{fragments=TRUE} is equivalent to
the behavior of the TEtranscripts algorithm. For further details see
\code{\link[GenomicAlignments]{summarizeOverlaps}()}.}

\item{\code{tolerance}}{A positive numeric scalar storing the minimum tolerance
above which the SQUAREM algorithm (Du and Varadhan, 2020) keeps iterating.
Default is \code{1e-4} and this value is passed to the \code{tol} parameter
of the \code{\link[SQUAREM]{squarem}()} function.}

\item{\code{maxIter}}{A positive integer scalar storing the maximum number of
iterations of the SQUAREM algorithm (Du and Varadhan, 2020). Default
is 100 and this value is passed to the \code{maxiter} parameter of the
\code{\link[SQUAREM]{squarem}()} function.}
}}

\examples{
bamfiles <- list.files(system.file("extdata", package="atena"),
                       pattern="*.bam", full.names=TRUE)
\dontrun{
## use the following two instructions to fetch annotations, they are here
## commented out to enable running this example quickly when building and
## checking the package
rmskat <- annotaTEs(genome="dm6", parsefun=rmskatenaparser,
                    strict=FALSE, insert=500)
rmskLTR <- getLTRs(rmskat, relLength=0.8,
                   fullLength=TRUE,
                   partial=TRUE,
                   otherLTR=TRUE)
}

## DO NOT TYPE THIS INSTRUCTION, WHICH JUST LOADS A PRE-COMPUTED ANNOTATION
## YOU SHOULD USE THE INSTRUCTIONS ABOVE TO FETCH ANNOTATIONS
rmskLTR <- readRDS(system.file("extdata", "rmskatLTRrlen80flenpartoth.rds",
                               package="atena"))


library(TxDb.Dmelanogaster.UCSC.dm6.ensGene)
txdb <- TxDb.Dmelanogaster.UCSC.dm6.ensGene
txdb_genes <- genes(txdb)

## build a parameter object for TEtranscripts
ttpar <- TEtranscriptsParam(bamfiles,
                            teFeatures=rmskLTR,
                            geneFeatures=txdb_genes,
                            singleEnd=TRUE,
                            ignoreStrand=TRUE,
                            aggregateby="repName")
ttpar

}
\references{
Jin Y et al. TEtranscripts: a package for including transposable elements
in differential expression analysis of RNA-seq datasets.
Bioinformatics. 2015;31(22):3593-3599. DOI:
\url{https://doi.org/10.1093/bioinformatics/btv422}

Jin Y et al. TEtranscripts: a package for including transposable elements
in differential expression analysis of RNA-seq datasets.
Bioinformatics. 2015;31(22):3593-3599. DOI:
\url{https://doi.org/10.1093/bioinformatics/btv422}
}
