% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBambu.R
\name{plotBambu}
\alias{plotBambu}
\title{plot.bambu}
\usage{
plotBambu(
  se,
  group.variable = NULL,
  type = c("annotation", "pca", "heatmap"),
  gene_id = NULL,
  transcript_id = NULL
)
}
\arguments{
\item{se}{An summarized experiment object obtained from \code{\link{bambu}}
or \code{\link{transcriptToGeneExpression}}.}

\item{group.variable}{Variable for grouping in plot, has be to provided if
choosing to plot PCA.}

\item{type}{plot type variable, a values of annotation for a single gene with
heatmap for isoform expressions,  pca,  or heatmap, see details.}

\item{gene_id}{specifying the gene_id for plotting gene annotation, either
gene_id or transcript_id has to be provided when type = "annotation".}

\item{transcript_id}{specifying the transcript_id for plotting transcript
annotation, either gene_id or transcript_id has to be provided when 
type = "annotation"}
}
\value{
A heatmap plot for all samples
}
\description{
plotSEOuptut
}
\details{
\code{\link{type}} indicates the type of plots to be plotted. There
are two types of plots can be chosen, PCA or heatmap.
}
\examples{
se <- readRDS(system.file("extdata",
"seOutputCombined_SGNex_A549_directRNA_replicate5_run1_chr9_1_1000000.rds",
package = "bambu"))
plotBambu(se, type = "PCA")
}
