% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-plots.R
\name{plotTable}
\alias{plotTable}
\title{Generate a table of differential localisations}
\usage{
plotTable(params, all = FALSE, fcol)
}
\arguments{
\item{params}{An instance of class \code{bandleParams} or an instance of
class \code{MSnSetList} of length 2.}

\item{all}{A \code{logical} specifying whether to count all proteins or only
show those that have changed in location between conditions. Default is
\code{FALSE}.}

\item{fcol}{If \code{params} is a \code{list} of \code{MSnSets}. Then
\code{fcol} must be defined. This is a \code{character} vector of length 2
to set different labels for each dataset. If only one label is specified,
and the \code{character} is of length 1 then this single label will be
used to identify the annotation column in both datasets.}
}
\value{
Returns a summary table of translocations of proteins between conditions.
}
\description{
This function produces a table summarising differential localisation results
between two experiments
}
\examples{
## Generate some example data
library("pRolocdata")
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                      numRep = 4L,
                      numDyn = 100L)
data <- tansim$lopitrep
control <- data[1:2]
treatment <- data[3:4]

## fit GP params
gpParams <- lapply(tansim$lopitrep, function(x) 
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))

## run bandle
res <- bandle(objectCond1 = control,
              objectCond2 = treatment, 
              gpParams = gpParams,
              fcol = "markers",  
              numIter = 5L, 
              burnin = 1L, 
              thin = 2L,
              numChains = 2, 
              BPPARAM = SerialParam(RNGseed = 1),
              seed = 1)
               
## Process bandle results
bandleres <- bandleProcess(res)

## Tabulate results
plotTable(bandleres)  
}
