% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarcodeSignif.R
\name{plotSignifBarcodeHeatmap}
\alias{plotSignifBarcodeHeatmap}
\title{Plot Barcodes categorized by significant change using a Heatmap}
\usage{
plotSignifBarcodeHeatmap(
  barbieQ,
  barcodeMetric = "CPM",
  sampleAnnotation = NULL
)
}
\arguments{
\item{barbieQ}{A \code{barbieQ} object created by the \link{createBarbieQ} function,
updated with Barcode test results by calling the \link{testBarcodeSignif} function.}

\item{barcodeMetric}{A string indicating what to visualize.
Defaults to \code{CPM}. Options include: 'CPM' and 'occurrence'.}

\item{sampleAnnotation}{A column Annotation object created by the
\link[ComplexHeatmap:HeatmapAnnotation]{ComplexHeatmap::HeatmapAnnotation} function. Defaults to samples annotated
by the groups to be compared.}
}
\value{
A \code{Heatmap} S4 class object displaying the significance level
of Barcodes in Heatmap annotations.
}
\description{
\code{plotSignifBarcodeHeatmap()} uses the Heatmap annotations to visualize the
significance level of each Barcode in differential proportion or occurrence,
as determined by the \link{testBarcodeSignif} function.
}
\examples{
Block <- c(1, 1, 2, 3, 3, 4, 1, 1, 2, 3, 3, 4)
Treat <- factor(rep(c('ctrl', 'drug'), each = 6))
Time <- rep(rep(seq_len(2), each = 3), 2)
nbarcodes <- 50
nsamples <- 12
count <- abs(matrix(rnorm(nbarcodes * nsamples), nbarcodes, nsamples))
rownames(count) <- paste0('Barcode', seq_len(nbarcodes))
barbieQ <- createBarbieQ(count, data.frame(Treat = Treat, Time = Time))
testBB <- testBarcodeSignif(barbieQ, sampleGroup = 'Treat')
plotSignifBarcodeHeatmap(barbieQ = testBB)
}
