% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/BatchelorParam.R
\docType{class}
\name{BatchelorParam-class}
\alias{BatchelorParam-class}
\alias{ClassicMnnParam-class}
\alias{FastMnnParam-class}
\alias{RescaleParam-class}
\alias{RegressParam-class}
\alias{NoCorrectParam-class}
\alias{ClassicMnnParam}
\alias{FastMnnParam}
\alias{RescaleParam}
\alias{RegressParam}
\alias{NoCorrectParam}
\title{BatchelorParam methods}
\usage{
ClassicMnnParam(...)

FastMnnParam(...)

RescaleParam(...)

RegressParam(...)

NoCorrectParam(...)
}
\arguments{
\item{...}{Named arguments to pass to individual methods upon dispatch.
These should not include arguments named in the \code{\link{batchCorrect}} generic.}
}
\value{
The constructors will return a BatchelorParam object of the specified subclass, containing parameter settings for the corresponding batch correction method.
}
\description{
Constructors and methods for the batchelor parameter classes.
}
\details{
BatchelorParam objects are intended to store method-specific parameter settings to pass to the \code{\link{batchCorrect}} generic.
These values should refer to data-agnostic parameters; parameters that depend on data (or the data itself) should be specified directly in the \code{\link{batchCorrect}} call.

The BatchelorParam classes are all derived from \linkS4class{SimpleList} objects and have the same available methods, e.g., \code{[[}, \code{$}.
These can be used to access or modify the object after construction.

Note that the BatchelorParam class itself is not useful and should not be constructed directly.
Instead, users should use the constructors shown above to create instances of the desired subclass.
}
\examples{
# Specifying the number of neighbors, dimensionality.
fp <- FastMnnParam(k=20, d=10)
fp

# List-like behaviour:
fp$k
fp$k <- 10
fp$k

}
\seealso{
\code{\link{batchCorrect}}, where the BatchelorParam objects are used for dispatch to individual methods.
}
\author{
Aaron Lun
}
