% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIOR_FUNCTIONS.R
\name{EstPrior}
\alias{EstPrior}
\title{Estimate size and mu for Negative Binomial distribution
for each gene using MME method}
\usage{
EstPrior(Data, verbose = TRUE)
}
\arguments{
\item{Data}{A matrix of single-cell expression where rows
are genes and columns are samples (cells). \code{Data}
can be of class \code{SummarizedExperiment} (the
assays slot contains the expression matrix,
is named "Counts"), just \code{matrix} or sparse matrix.}

\item{verbose}{print out status messages. Default is TRUE.}
}
\value{
List containing estimated mu and
size for each gene.
}
\description{
Input raw data and return
estimated size and mu for each gene using the MME method.
}
\details{
mu and size are two parameters of the prior that
need to be specified for each gene in bayNorm.
They are parameters of negative binomial distribution.
The variance is \eqn{mu + mu^2/size} in this parametrization.
}
\examples{
data('EXAMPLE_DATA_list')
#Return estimated mu and size for each gene using MME method.
MME_est<-EstPrior(Data=EXAMPLE_DATA_list$inputdata[,seq(1,30)],
verbose=TRUE)
}
