% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIOR_FUNCTIONS.R
\name{Prior_fun}
\alias{Prior_fun}
\title{A wrapper function of \code{EstPrior}
and \code{AdjustSIZE_fun}}
\usage{
Prior_fun(
  Data,
  BETA_vec,
  parallel = TRUE,
  NCores = 5,
  FIX_MU = TRUE,
  GR = FALSE,
  BB_SIZE = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{Data}{A matrix of single-cell expression where rows
are genes and columns are samples (cells). \code{Data}
can be of class \code{SummarizedExperiment} (the
assays slot contains the expression matrix,
is named "Counts"), just \code{matrix} or sparse matrix.}

\item{BETA_vec}{A vector of capture efficiencies of cells.}

\item{parallel}{If TRUE, 5 cores will be used for
parallelization. Default is TRUE.}

\item{NCores}{number of cores to use, default is 5.
This will be used to set up a parallel environment
using either MulticoreParam (Linux, Mac) or
SnowParam (Windows) with \code{NCores} using the
package \code{BiocParallel}.}

\item{FIX_MU}{If TRUE, then 1D optimization, otherwise
2D optimization (slow). Default is TRUE.}

\item{GR}{If TRUE, the gradient function will be used
in optimization. However since the gradient function
itself is very complicated, it does not help too much
in speeding up. Default is FALSE.}

\item{BB_SIZE}{If TRUE, estimate BB size, and then use
it for adjusting MME SIZE. Use the adjusted MME size
for bayNorm. Default is TRUE.}

\item{verbose}{Print out status messages. Default is TRUE.}
}
\value{
List of estimated parameters: mean
expression of genes
and size of each gene.
}
\description{
A wrapper function for estimating the parameters
of prior using the hybrid method adjusted MME estimates based
on maximization of marginal likelihood. Input raw data and a
vector of capture efficiencies of cells.
}
\details{
By Default, this function will estimate mu and
size for each gene using MME method. If \code{BB_size}
is enable, spectral projected gradient method from BB
package will be implemented to estimate 'BB size' by
maximizing marginal likelihood function. MME estimated
size will be adjusted according to BB size. BB size itself
will not be used in bayNorm this is because that in
our simulation we found that MME estimated mu and size
have more accurate relationship, but MME estimated
size deviates from the true value. BB size is overall
more close to the true size but it does not possess a
reasonable relationship with either MME estimated mu or
BB estimated mu.
}
\examples{
data('EXAMPLE_DATA_list')
PRIOR_RESULT<-Prior_fun(Data=EXAMPLE_DATA_list$inputdata[,seq(1,30)],
BETA_vec = EXAMPLE_DATA_list$inputbeta[seq(1,30)],parallel=FALSE,
NCores=5,FIX_MU=TRUE,GR=FALSE,BB_SIZE=TRUE,verbose=TRUE)

}
