% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beadsRR.R
\name{.beadsRRBeer}
\alias{.beadsRRBeer}
\title{Function to run the beads-only round robin using BEER}
\usage{
.beadsRRBeer(
  object,
  prior.params = list(method = "edgeR", a_pi = 2, b_pi = 300, a_phi = 1.25, b_phi =
    0.1, a_c = 80, b_c = 20, fc = 1),
  beads.args = list(lower = 1),
  jags.params = list(n.chains = 1, n.adapt = 1000, n.iter = 10000, thin = 1, na.rm =
    TRUE, burn.in = 0, post.thin = 1, seed = as.numeric(format(Sys.Date(), "\%Y\%m\%d"))),
  sample.dir = NULL,
  assay.names = c(phi = NULL, phi_Z = "logfc", Z = "prob", c = "sampleInfo", pi =
    "sampleInfo"),
  summarize = TRUE,
  BPPARAM = bpparam()
)
}
\arguments{
\item{object}{PhIPData object}

\item{prior.params}{named list of prior parameters}

\item{beads.args}{named list of parameters supplied to estimating beads-only
prior parameters (a_0, b_0)}

\item{jags.params}{named list of parameters for running MCMC using JAGS}

\item{sample.dir}{path to temporarily store RDS files for each sample run,
if \code{NULL} then \code{[base::tempdir]} is used to temporarily store
MCMC output and cleaned afterwards.}

\item{assay.names}{named vector indicating where MCMC results should be
stored in the PhIPData object}

\item{summarize}{logical indicating whether to return a PhIPData object.}

\item{BPPARAM}{\code{[BiocParallel::BiocParallelParam]} passed to
BiocParallel functions.}
}
\value{
vector of process IDs or a PhIPData object
}
\description{
Each sample is run in comparison to all other beads-only samples to
approximate the false positive rate of detecting enrichments.
}
